/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 * 	  Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.application;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class WorkbenchAdvisor {
  @Inject
  @Extension
  private Common _common;

  @Inject
  private WorkbenchWindowAdvisor xptWorkbenchWindowAdvisor;

  public CharSequence className(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    String _workbenchAdvisorClassName = it.getWorkbenchAdvisorClassName();
    _builder.append(_workbenchAdvisorClassName);
    return _builder;
  }

  public CharSequence packageName(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getPackageName();
    _builder.append(_packageName);
    return _builder;
  }

  public CharSequence qualifiedClassName(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence fullPath(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence WorkbenchAdvisor(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" extends org.eclipse.ui.application.WorkbenchAdvisor {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _perspectiveId = this.perspectiveId(it);
    _builder.append(_perspectiveId, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _initialWindowPerspectiveId = this.getInitialWindowPerspectiveId(it);
    _builder.append(_initialWindowPerspectiveId, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _initialize = this.initialize(it);
    _builder.append(_initialize, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createWorkbenchWindowAdvisor = this.createWorkbenchWindowAdvisor(it);
    _builder.append(_createWorkbenchWindowAdvisor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence perspectiveId(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static final String PERSPECTIVE_ID = \"");
    String _perspectiveId = it.getPerspectiveId();
    _builder.append(_perspectiveId);
    _builder.append("\"; ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence getInitialWindowPerspectiveId(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public String getInitialWindowPerspectiveId() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return PERSPECTIVE_ID;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence initialize(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void initialize(org.eclipse.ui.application.IWorkbenchConfigurer configurer) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.initialize(configurer);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("configurer.setSaveAndRestore(true);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence createWorkbenchWindowAdvisor(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.ui.application.WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.ui.application.IWorkbenchWindowConfigurer configurer) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return new ");
    CharSequence _qualifiedClassName = this.xptWorkbenchWindowAdvisor.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t");
    _builder.append("(configurer);");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence additions(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
