/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.util;

import java.util.IdentityHashMap;
import org.eclipse.cbi.p2repo.util.ExceptionUtils;
import org.eclipse.cbi.p2repo.util.LogLevel;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class P2RepoUtil
extends Plugin {
    private static Plugin plugin;
    private LogLevel eclipseLogLevel = LogLevel.INFO;
    private LogLevel consoleLogLevel = LogLevel.INFO;
    private IdentityHashMap<Object, ServiceReference<?>> services;

    public static P2RepoUtil getPlugin() {
        if (plugin == null) {
            plugin = new P2RepoUtil();
        }
        return (P2RepoUtil)plugin;
    }

    public static String getPluginID() {
        return P2RepoUtil.getPlugin().getBundle() == null ? "org.eclipse.cbi.p2repo.util" : plugin.getBundle().getSymbolicName();
    }

    public P2RepoUtil() {
        plugin = this;
    }

    public final LogLevel getConsoleLogLevel() {
        return this.consoleLogLevel;
    }

    public final LogLevel getEclipseLogLevel() {
        return this.eclipseLogLevel;
    }

    public <T> T getService(Class<T> serviceClass) throws CoreException {
        return this.getService(serviceClass, null);
    }

    public <T> T getService(Class<T> serviceClass, String filter) throws CoreException {
        ServiceReference[] serviceRef;
        BundleContext context = P2RepoUtil.getPlugin().getBundle().getBundleContext();
        String serviceName = serviceClass.getName();
        try {
            serviceRef = context.getAllServiceReferences(serviceName, filter);
        }
        catch (InvalidSyntaxException e) {
            throw ExceptionUtils.wrap(e);
        }
        if (serviceRef == null || serviceRef.length == 0) {
            throw ExceptionUtils.fromMessage("Missing OSGi Service %s", serviceName);
        }
        T service = serviceClass.cast(context.getService(serviceRef[0]));
        if (this.services == null) {
            this.services = new IdentityHashMap();
        }
        this.services.put(service, serviceRef[0]);
        return service;
    }

    public final void setConsoleLogLevel(LogLevel consoleLogLevel) {
        this.consoleLogLevel = consoleLogLevel;
    }

    public final void setEclipseLogLevel(LogLevel eclipseLogLevel) {
        this.eclipseLogLevel = eclipseLogLevel;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public void ungetService(Object service) {
        ServiceReference<?> serviceRef;
        if (this.services != null && service != null && (serviceRef = this.services.remove(service)) != null) {
            P2RepoUtil.getPlugin().getBundle().getBundleContext().ungetService(serviceRef);
        }
    }
}

