/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.controlmode;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.participants.IControlCommandParticipant;
import org.eclipse.papyrus.infra.services.controlmode.participants.IUncontrolCommandParticipant;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.Activator;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.PackageRefactoringContext;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.commands.ConfirmSaveCommand;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.commands.DecoratorModelRefactoringCommandFactory;
import org.eclipse.uml2.uml.Package;

public class DecoratorModelControlModeParticipant
implements IControlCommandParticipant,
IUncontrolCommandParticipant {
    static final String PARTICIPANT_ID = "org.eclipse.papyrus.uml.decoratormodel.controlmode.participant";

    public String getID() {
        return PARTICIPANT_ID;
    }

    public int getPriority() {
        return -100;
    }

    public boolean provideControlCommand(ControlModeRequest request) {
        return this.hasExternalProfileApplications(request, true);
    }

    public ICommand getPreControlCommand(ControlModeRequest request) {
        Object result = null;
        if (request.isUIAction() && this.hasExternalProfileApplications(request, false)) {
            result = new ConfirmSaveCommand(Activator.getActiveWorkbenchWindow().getShell());
        }
        try {
            result = CompositeCommand.compose(result, (ICommand)DecoratorModelRefactoringCommandFactory.createPreCommand(request));
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
            result = new UnexecutableCommand(e.getStatus());
        }
        return result;
    }

    public ICommand getPostControlCommand(ControlModeRequest request) {
        try {
            return DecoratorModelRefactoringCommandFactory.createPostCommand(request);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
            return new UnexecutableCommand(e.getStatus());
        }
    }

    public boolean provideUnControlCommand(ControlModeRequest request) {
        return this.hasExternalProfileApplications(request, true);
    }

    public ICommand getPreUncontrolCommand(ControlModeRequest request) {
        Object result = null;
        if (request.isUIAction() && this.hasExternalProfileApplications(request, false)) {
            result = new ConfirmSaveCommand(Activator.getActiveWorkbenchWindow().getShell());
        }
        try {
            result = CompositeCommand.compose(result, (ICommand)DecoratorModelRefactoringCommandFactory.createPreCommand(request));
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
            result = new UnexecutableCommand(e.getStatus());
        }
        return result;
    }

    public ICommand getPostUncontrolCommand(ControlModeRequest request) {
        try {
            return DecoratorModelRefactoringCommandFactory.createPostCommand(request);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
            return new UnexecutableCommand(e.getStatus());
        }
    }

    protected boolean hasExternalProfileApplications(ControlModeRequest request, boolean includeLoaded) {
        boolean result = false;
        for (Package next : PackageRefactoringContext.getPackagesBeingControlled(request.getTargetObject())) {
            try {
                result = !DecoratorModelUtils.getAllDecoratorModelAppliedProfileDefinitions((Package)next, (boolean)includeLoaded, (boolean)true).isEmpty();
            }
            catch (CoreException e) {
                result = true;
                Activator.getDefault().getLog().log(e.getStatus());
            }
            if (result) break;
        }
        return result;
    }
}

