/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.tools;

import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.AspectUnspecifiedTypeConnectionTool;
import org.eclipse.papyrus.uml.diagram.sequence.util.TooltipHook;

public class SequenceSpecificConnectionTool
extends AspectUnspecifiedTypeConnectionTool {
    private EditPart source;
    private TooltipHook tooltipHook = null;

    public SequenceSpecificConnectionTool(List<IElementType> elementTypes) {
        super(elementTypes);
        this.setDisabledCursor(Cursors.NO);
    }

    public void setViewer(EditPartViewer viewer) {
        super.setViewer(viewer);
        if (this.tooltipHook == null || !this.tooltipHook.isHooked(viewer)) {
            if (this.tooltipHook != null) {
                this.tooltipHook.dispose();
            }
            this.tooltipHook = new TooltipHook(viewer);
        }
    }

    public void deactivate() {
        super.deactivate();
        if (this.tooltipHook != null) {
            this.tooltipHook.dispose();
            this.tooltipHook = null;
        }
    }

    protected void setConnectionSource(EditPart source) {
        this.source = source;
        super.setConnectionSource(source);
    }

    public void clearConnectionFeedback() {
        if (!this.isShowingSourceFeedback()) {
            return;
        }
        if (this.source != null) {
            Request req = this.getSourceRequest();
            req.setType((Object)"connection end");
            this.source.eraseSourceFeedback(req);
        }
    }
}

