/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.tuple.primitive;

import org.eclipse.collections.api.tuple.primitive.ObjectLongPair;
import org.eclipse.collections.impl.block.factory.Comparators;

public class ObjectLongPairImpl<T>
implements ObjectLongPair<T> {
    private static final long serialVersionUID = 1L;
    private final T one;
    private final long two;

    ObjectLongPairImpl(T newOne, long newTwo) {
        this.one = newOne;
        this.two = newTwo;
    }

    @Override
    public T getOne() {
        return this.one;
    }

    @Override
    public long getTwo() {
        return this.two;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectLongPair)) {
            return false;
        }
        ObjectLongPair that = (ObjectLongPair)o;
        return Comparators.nullSafeEquals(this.one, that.getOne()) && this.two == that.getTwo();
    }

    public int hashCode() {
        int result = this.one == null ? 0 : this.one.hashCode();
        result = 29 * result + (int)(this.two ^ this.two >>> 32);
        return result;
    }

    public String toString() {
        return this.one + ":" + this.two;
    }

    @Override
    public int compareTo(ObjectLongPair<T> that) {
        int i = ((Comparable)this.one).compareTo(that.getOne());
        if (i != 0) {
            return i;
        }
        return this.two < that.getTwo() ? -1 : (this.two > that.getTwo() ? 1 : 0);
    }
}

