/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedIntProcedure;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;

public final class ImmutableIntSetSerializationProxy
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private IntSet set;

    public ImmutableIntSetSerializationProxy() {
    }

    public ImmutableIntSetSerializationProxy(IntSet set) {
        this.set = set;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.set.size());
        try {
            this.set.forEach(new CheckedIntProcedure(){

                @Override
                public void safeValue(int item) throws Exception {
                    out.writeInt(item);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        IntHashSet deserializedSet = new IntHashSet(size);
        for (int i = 0; i < size; ++i) {
            deserializedSet.add(in.readInt());
        }
        this.set = deserializedSet;
    }

    private Object readResolve() {
        return this.set.toImmutable();
    }
}

