/*****************************************************************************
 * Copyright (c) 2023 CEA LIST, Obeo.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Obeo - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrus.sirius.junit.util.diagram;

import org.eclipse.papyrus.sirius.junit.utils.diagram.creation.checker.SemanticAndGraphicalCreationChecker;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.uml2.uml.Element;

/**
 * Abstract Tests for TopNode creation on Diagram
 *
 * @author <a href="mailto:jessy.mallet@obeo.fr">Jessy Mallet</a>
 */
public abstract class AbstractCreateTopNodeOnDiagramTests extends AbstractCreateNodeTests {


	/**
	 * {@inheritDoc}
	 * <p>
	 * The element is the root model.
	 * </p>
	 */
	@Override
	protected final Element getSemanticOwner() {
		return this.root;
	}

	/**
	 * {@inheritDoc}
	 * <p>
	 * The container is the Sirius {@link DDiagram}.
	 * </p>
	 */
	@Override
	protected final DSemanticDiagram getTopGraphicalContainer() {
		return getDDiagram();
	}


	/**
	 * Creates an element using the tool whom name is provided.
	 *
	 * @param creationToolId
	 *            the ID of the creation tool to use
	 * @param checker
	 *            the checker to use to validate the creation
	 */
	protected void createNode(final String creationToolId, final SemanticAndGraphicalCreationChecker checker) {
		super.createNode(creationToolId, checker, getTopGraphicalContainer());
	}
}
