/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.sequence.services.reorder;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.SequenceDiagramOrderServices;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.utils.SequenceDiagramUMLHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class SequenceDiagramEndReorderHelper {
    private final SequenceDiagramOrderServices orderService = new SequenceDiagramOrderServices();
    private final SequenceDiagramUMLHelper umlHelper = new SequenceDiagramUMLHelper();

    /*
     * WARNING - void declaration
     */
    public void applyBothEndsReorder(Element interactionElement, EAnnotation newStartingEndPredecessor, EAnnotation newFinishingEndPredecessor, List<EAnnotation> endsOrdering) {
        EAnnotation startEnd = Objects.requireNonNull(this.orderService.getStartingEnd(interactionElement));
        EAnnotation finishEnd = Objects.requireNonNull(this.orderService.getFinishingEnd(interactionElement));
        List<Object> innerEndsToMove = Collections.emptyList();
        Element element = interactionElement;
        if (element instanceof InteractionFragment) {
            void fragment;
            InteractionFragment interactionFragment = (InteractionFragment)element;
            InteractionFragment cfr_ignored_0 = (InteractionFragment)element;
            innerEndsToMove = endsOrdering.subList(endsOrdering.indexOf(startEnd) + 1, endsOrdering.indexOf(finishEnd)).stream().filter(arg_0 -> this.lambda$0((InteractionFragment)fragment, arg_0)).toList();
        }
        endsOrdering.remove(startEnd);
        endsOrdering.remove(finishEnd);
        endsOrdering.removeAll(innerEndsToMove);
        int newStartEndIndex = endsOrdering.indexOf(newStartingEndPredecessor) + 1;
        endsOrdering.add(newStartEndIndex, startEnd);
        endsOrdering.addAll(newStartEndIndex + 1, innerEndsToMove);
        if (newStartingEndPredecessor == newFinishingEndPredecessor || newFinishingEndPredecessor == startEnd) {
            endsOrdering.add(newStartEndIndex + innerEndsToMove.size() + 1, finishEnd);
        } else {
            endsOrdering.add(endsOrdering.indexOf(newFinishingEndPredecessor) + 1, finishEnd);
        }
    }

    public void applySingleEndReorder(Element interactionElement, boolean start, EAnnotation predecessor, List<EAnnotation> endsOrdering) {
        EAnnotation end = start ? this.orderService.getStartingEnd(interactionElement) : this.orderService.getFinishingEnd(interactionElement);
        endsOrdering.remove(end);
        int newEndIndex = endsOrdering.indexOf(predecessor) + 1;
        endsOrdering.add(newEndIndex, end);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isEndInFragment(EAnnotation end, InteractionFragment fragment) {
        InteractionFragment semanticEnd = this.orderService.getEndFragment(end);
        InteractionFragment interactionFragment = semanticEnd;
        if (interactionFragment instanceof MessageOccurrenceSpecification) {
            void messageOccurrenceSpecification;
            MessageOccurrenceSpecification messageOccurrenceSpecification2 = (MessageOccurrenceSpecification)interactionFragment;
            MessageOccurrenceSpecification cfr_ignored_0 = (MessageOccurrenceSpecification)interactionFragment;
            OccurrenceSpecification otherEnd = this.umlHelper.getOtherEnd((OccurrenceSpecification)messageOccurrenceSpecification);
            return this.umlHelper.isCoveringASubsetOf((InteractionFragment)messageOccurrenceSpecification, fragment) || this.umlHelper.isCoveringASubsetOf((InteractionFragment)otherEnd, fragment);
        }
        return this.umlHelper.isCoveringASubsetOf(semanticEnd, fragment);
    }

    private /* synthetic */ boolean lambda$0(InteractionFragment interactionFragment, EAnnotation end) {
        return this.isEndInFragment(end, interactionFragment);
    }
}

