/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.sequence.services;

import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.LabelElementNameProvider;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.UMLLabelServices;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.utils.SequenceDiagramUMLHelper;
import org.eclipse.papyrus.uml.domain.services.labels.INamedElementNameProvider;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;

public class SequenceDiagramUMLLabelServices {
    private static final String UNDEFINED = "<Undefined>";
    private final UMLLabelServices labelServices = new UMLLabelServices();
    private final INamedElementNameProvider namedElementNameProvider = new LabelElementNameProvider();

    public String renderMessageLabelSD(Message message, DDiagram diagram) {
        String label;
        Objects.requireNonNull(message);
        NamedElement signature = message.getSignature();
        if (signature instanceof Operation) {
            label = this.computeOperationLabel((Operation)signature);
        } else if (signature instanceof Signal) {
            label = this.computeSignalLabel((Signal)signature);
        } else if (signature != null) {
            label = this.namedElementNameProvider.getName(signature);
        } else {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.labelServices.renderLabel((EObject)message, diagram));
            String arguments = this.computeMessageArgumentsLabel(message, diagram);
            buffer.append(arguments);
            label = buffer.toString();
        }
        return label;
    }

    public String renderReferredInteractionLabelSD(InteractionUse interactionUse) {
        String result = "";
        if (interactionUse.getRefersTo() != null) {
            result = interactionUse.getRefersTo().getName();
        }
        return result;
    }

    public String renderTimeElementLabelSD(EAnnotation event, DDiagram diagram) {
        return SequenceDiagramUMLHelper.getTimeElementFromEnd(event).map(observation -> this.labelServices.renderLabel((EObject)observation, diagram)).orElse("");
    }

    private String computeOperationLabel(Operation operation) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.namedElementNameProvider.getName((NamedElement)operation));
        String parameters = this.computeOperationParametersLabel(operation);
        buffer.append(parameters);
        String returnParameter = this.computeReturnParameterLabel(operation);
        buffer.append(returnParameter);
        return buffer.toString();
    }

    private String computeSignalLabel(Signal signal) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.namedElementNameProvider.getName((NamedElement)signal));
        String properties = this.computeSignalPropertiesLabel(signal);
        buffer.append(properties);
        return buffer.toString();
    }

    private String computeMessageArgumentsLabel(Message message, DDiagram diagram) {
        if (message.getArguments().isEmpty()) {
            return "";
        }
        return message.getArguments().stream().map(argument -> this.computeArgumentLabel((ValueSpecification)argument, diagram)).collect(Collectors.joining(", ", "(", ")"));
    }

    private String computeSignalPropertiesLabel(Signal signal) {
        if (signal.getOwnedAttributes().isEmpty()) {
            return "";
        }
        return signal.getOwnedAttributes().stream().map(this::computePropertyLabel).collect(Collectors.joining(", ", "(", ")"));
    }

    private String computeOperationParametersLabel(Operation operation) {
        Object result = "";
        String operationParameters = operation.getOwnedParameters().stream().filter(parameter -> !parameter.getDirection().equals((Object)ParameterDirectionKind.RETURN_LITERAL)).map(this::computeParameterLabel).collect(Collectors.joining(", "));
        if (!operationParameters.isBlank()) {
            result = "(" + operationParameters + ")";
        }
        return result;
    }

    private String computeReturnParameterLabel(Operation operation) {
        Parameter returnParameter = operation.getOwnedParameters().stream().filter(parameter -> parameter.getDirection().equals((Object)ParameterDirectionKind.RETURN_LITERAL)).findFirst().orElse(null);
        StringBuffer buffer = new StringBuffer();
        if (returnParameter != null) {
            buffer.append(":");
            buffer.append(" ");
            String typeString = this.computeTypeLabel(returnParameter.getType());
            buffer.append(typeString);
        }
        return buffer.toString();
    }

    private String computeArgumentLabel(ValueSpecification argument, DDiagram diagram) {
        String typeString = this.computeTypeLabel(argument.getType());
        return typeString + " " + this.labelServices.renderLabel((EObject)argument, diagram);
    }

    private String computePropertyLabel(Property property) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.namedElementNameProvider.getName((NamedElement)property));
        buffer.append(":");
        buffer.append(" ");
        String typeString = this.computeTypeLabel(property.getType());
        buffer.append(typeString);
        return buffer.toString();
    }

    private String computeParameterLabel(Parameter parameter) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.namedElementNameProvider.getName((NamedElement)parameter));
        buffer.append(":");
        buffer.append(" ");
        String typeString = this.computeTypeLabel(parameter.getType());
        buffer.append(typeString);
        return buffer.toString();
    }

    private String computeTypeLabel(Type type) {
        String result = UNDEFINED;
        if (type != null) {
            result = this.namedElementNameProvider.getName((NamedElement)type);
        }
        return result;
    }
}

