/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.clazz.services;

import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.AssociationServices;
import org.eclipse.sirius.diagram.EdgeArrows;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Property;

public class AssociationEndDecoratorUtils {
    private static final int aggregation = 2;
    private static final int composition = 4;
    private static final int navigable = 1;
    private static final int owned = 8;

    private static int getSourceType(Association association) {
        if (association == null || association.getMemberEnds().size() < 2) {
            return 0;
        }
        Property sourceProperty = AssociationServices.INSTANCE.getSourceProperty(association);
        Property targetProperty = AssociationServices.INSTANCE.getTargetProperty(association);
        int sourceType = 0;
        if (!targetProperty.getOwner().equals(association)) {
            sourceType += 8;
            ++sourceType;
        }
        if (sourceProperty.getAggregation() == AggregationKind.SHARED_LITERAL) {
            sourceType += 2;
        }
        if (sourceProperty.getAggregation() == AggregationKind.COMPOSITE_LITERAL) {
            sourceType += 4;
        }
        if (association.getNavigableOwnedEnds().contains((Object)targetProperty)) {
            ++sourceType;
        }
        return sourceType;
    }

    private static int getTargetType(Association association) {
        if (association == null || association.getMemberEnds().size() < 2) {
            return 0;
        }
        Property sourceProperty = AssociationServices.INSTANCE.getSourceProperty(association);
        Property targetProperty = AssociationServices.INSTANCE.getTargetProperty(association);
        int targetType = 0;
        if (!sourceProperty.getOwner().equals(association)) {
            targetType += 8;
            ++targetType;
        }
        if (targetProperty.getAggregation() == AggregationKind.SHARED_LITERAL) {
            targetType += 2;
        }
        if (targetProperty.getAggregation() == AggregationKind.COMPOSITE_LITERAL) {
            targetType += 4;
        }
        if (association.getNavigableOwnedEnds().contains((Object)sourceProperty)) {
            ++targetType;
        }
        return targetType;
    }

    public static EdgeArrows getSourceDecorator(Association association) {
        return AssociationEndDecoratorUtils.getDecorator(AssociationEndDecoratorUtils.getSourceType(association));
    }

    public static EdgeArrows getTargetDecorator(Association association) {
        return AssociationEndDecoratorUtils.getDecorator(AssociationEndDecoratorUtils.getTargetType(association));
    }

    private static EdgeArrows getDecorator(int typeDecoration) {
        int ownedValue = typeDecoration / 8;
        int remain = typeDecoration % 8;
        int compositeValue = remain / 4;
        int aggregationValue = (remain %= 4) / 2;
        int navigationValue = (remain %= 2) / 1;
        if (ownedValue == 1) {
            if (compositeValue == 1) {
                if (navigationValue == 1) {
                    return AssociationEndDecoratorUtils.getOwnedNavigableCompositionDecoration();
                }
                return AssociationEndDecoratorUtils.getOwnedCompositionDecoration();
            }
            if (aggregationValue == 1) {
                if (navigationValue == 1) {
                    return AssociationEndDecoratorUtils.getOwnedNavigableAggregationDecoration();
                }
                return AssociationEndDecoratorUtils.getOwnedAggregationDecoration();
            }
            if (navigationValue == 1) {
                return AssociationEndDecoratorUtils.getOwnedNavigationDecoration();
            }
            return AssociationEndDecoratorUtils.getOwnedDecoration();
        }
        if (compositeValue == 1) {
            if (navigationValue == 1) {
                return AssociationEndDecoratorUtils.getNavigableCompositionDecoration();
            }
            return AssociationEndDecoratorUtils.getCompositionDecoration();
        }
        if (aggregationValue == 1) {
            if (navigationValue == 1) {
                return AssociationEndDecoratorUtils.getNavigableAggregationDecoration();
            }
            return AssociationEndDecoratorUtils.getAggregationDecoration();
        }
        if (navigationValue == 1) {
            return AssociationEndDecoratorUtils.getNavigationDecoration();
        }
        return EdgeArrows.NO_DECORATION_LITERAL;
    }

    private static EdgeArrows getNavigationDecoration() {
        return EdgeArrows.INPUT_ARROW_LITERAL;
    }

    private static EdgeArrows getAggregationDecoration() {
        return EdgeArrows.DIAMOND_LITERAL;
    }

    private static EdgeArrows getNavigableAggregationDecoration() {
        return EdgeArrows.INPUT_ARROW_WITH_DIAMOND_LITERAL;
    }

    private static EdgeArrows getCompositionDecoration() {
        return EdgeArrows.FILL_DIAMOND_LITERAL;
    }

    private static EdgeArrows getNavigableCompositionDecoration() {
        return EdgeArrows.INPUT_ARROW_WITH_FILL_DIAMOND_LITERAL;
    }

    private static EdgeArrows getOwnedDecoration() {
        return EdgeArrows.NO_DECORATION_LITERAL;
    }

    private static EdgeArrows getOwnedNavigationDecoration() {
        return EdgeArrows.INPUT_ARROW_LITERAL;
    }

    private static EdgeArrows getOwnedAggregationDecoration() {
        return EdgeArrows.DIAMOND_LITERAL;
    }

    private static EdgeArrows getOwnedNavigableAggregationDecoration() {
        return EdgeArrows.INPUT_ARROW_WITH_DIAMOND_LITERAL;
    }

    private static EdgeArrows getOwnedCompositionDecoration() {
        return EdgeArrows.FILL_DIAMOND_LITERAL;
    }

    private static EdgeArrows getOwnedNavigableCompositionDecoration() {
        return EdgeArrows.INPUT_ARROW_WITH_FILL_DIAMOND_LITERAL;
    }
}

