/**
 * Copyright (c) 2015, 2013, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Michael Golubev (Montages) - initial API and implementation
 * Anatoliy Tischenko - Initial API and implementation
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up override + type<template?>
 */
package xpt;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
@SuppressWarnings("all")
public class CodeStyle {
  @Inject
  @Extension
  private GenEditorGenerator_qvto _genEditorGenerator_qvto;

  /**
   * FIXME: [MG] inline this, we now safely assume everywhere that it is > 6
   */
  public CharSequence overrideC(final Object xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("@Override");
    _builder.newLine();
    return _builder;
  }

  public CharSequence overrideI(final Object xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("@Override");
    _builder.newLine();
    return _builder;
  }

  /**
   * The diamond operator, allows the right hand side of the assignment to be defined as a true generic instance with the same type parameters as the left side.
   */
  public String diamondOp(final GenCommonBase xptSelf, final String... tokens) {
    int _jdkComplianceLevel = this._genEditorGenerator_qvto.jdkComplianceLevel(xptSelf);
    boolean _lessThan = (_jdkComplianceLevel < 7);
    if (_lessThan) {
      StringConcatenation _builder = new StringConcatenation();
      String _join = IterableExtensions.join(((Iterable<?>)Conversions.doWrapArray(tokens)), ", ");
      _builder.append(_join);
      return _builder.toString();
    }
    return null;
  }
}
