/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers;

import com.google.common.collect.ListMultimap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.toolsmiths.plugin.builder.AbstractPapyrusBuilder;
import org.eclipse.papyrus.toolsmiths.plugin.builder.IPapyrusBuilderProvider;
import org.eclipse.papyrus.toolsmiths.plugin.builder.PapyrusBuilderKind;
import org.eclipse.papyrus.toolsmiths.plugin.builder.PluginCheckerBuilder;
import org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers.ArchitecturePluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ModelResourceMapper;
import org.osgi.service.component.annotations.Component;

@Component
public class ArchitectureBuilderProvider
implements IPapyrusBuilderProvider {
    public String getProblemMarkerType(PapyrusBuilderKind builderKind) {
        return "org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic";
    }

    public boolean providesBuilder(PapyrusBuilderKind builderKind, URI resourceURI) {
        return "architecture".equals(resourceURI.fileExtension());
    }

    public AbstractPapyrusBuilder getBuilder(PapyrusBuilderKind builderKind, IProject project) {
        PluginCheckerBuilder result = new PluginCheckerBuilder("org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic", this::mapArchitectureResources);
        switch (builderKind) {
            case MODEL_RESOURCE: {
                result = result.withChecker(ArchitecturePluginChecker.modelValidationCheckerFactory()).withChecker(ArchitecturePluginChecker.customModelCheckerFactory());
                break;
            }
            case BUNDLE_MANIFEST: {
                result = result.withChecker(ArchitecturePluginChecker.buildPropertiesCheckerFactory()).withChecker(ArchitecturePluginChecker.modelDependenciesCheckerFactory());
                break;
            }
            case PLUGIN_MANIFEST: {
                result = result.withChecker(ArchitecturePluginChecker.extensionsCheckerFactory());
            }
        }
        return result;
    }

    private ListMultimap<IFile, ArchitectureDomain> mapArchitectureResources(IProject project) {
        ModelResourceMapper mapper = new ModelResourceMapper((IContainer)project);
        return mapper.map(ModelResourceMapper.byExtension((String)"architecture"), ModelResourceMapper.resourceSets((EPackage.Registry)ResourceUtils.createWorkspaceAwarePackageRegistry()), ModelResourceMapper.rootsOfType(ArchitectureDomain.class));
    }
}

