/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.command;

import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.messages.Messages;

public class TouchResourceCommand
extends AbstractOverrideableCommand {
    private Resource resource;
    private boolean wasModified;

    public TouchResourceCommand(EditingDomain domain, Resource resource) {
        super(domain, Messages.TouchResourceCommand_0, Messages.TouchResourceCommand_1);
        this.resource = resource;
    }

    public void doDispose() {
        this.resource = null;
        super.doDispose();
    }

    protected boolean prepare() {
        return this.resource != null;
    }

    public void doExecute() {
        this.wasModified = this.resource.isModified();
        if (!this.wasModified) {
            this.resource.setModified(true);
        }
    }

    public void doUndo() {
        this.resource.setModified(this.wasModified);
    }

    public void doRedo() {
        if (!this.wasModified) {
            this.resource.setModified(true);
        }
    }

    public static Collector<Resource, ?, Command> toTouchCommand(EditingDomain domain) {
        return Collectors.collectingAndThen(Collectors.filtering(Predicate.not(Resource::isModified), Collectors.mapping(resource -> new TouchResourceCommand(domain, (Resource)resource), Collectors.reducing(Command::chain))), optional -> (Command)optional.orElse(IdentityCommand.INSTANCE));
    }
}

