/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.quickfix;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.CommonMarkerResolutionGenerator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public abstract class AbstractPapyrusWorkbenchMarkerResolution
extends WorkbenchMarkerResolution {
    private final int problemID;

    protected AbstractPapyrusWorkbenchMarkerResolution(int problemID) {
        this.problemID = problemID;
    }

    protected final int getProblemID() {
        return this.problemID;
    }

    public Image getImage() {
        ImageRegistry registry = Activator.getDefault().getImageRegistry();
        Image image = registry.get("/icons/full/obj16/papyrus.png");
        if (image == null) {
            registry.put("/icons/full/obj16/papyrus.png", AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.toolsmiths.validation.common", (String)"/icons/full/obj16/papyrus.png"));
            image = registry.get("/icons/full/obj16/papyrus.png");
        }
        return image;
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        return (IMarker[])this.findSimilarMarkers(markers).toArray(IMarker[]::new);
    }

    protected Stream<IMarker> findSimilarMarkers(IMarker[] markers) {
        Function<IMarker, Integer> problemID = CommonMarkerResolutionGenerator::getProblemID;
        Predicate<IMarker> sameProblem = problemID.andThen(Predicate.isEqual(this.getProblemID())::test)::apply;
        return Stream.of(markers).filter(sameProblem);
    }
}

