/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.papyrus.customization.properties.generation.generators.IGenerator;
import org.eclipse.papyrus.customization.properties.generation.generators.ProfileGenerator;
import org.eclipse.papyrus.infra.constraints.ConstraintDescriptor;
import org.eclipse.papyrus.infra.constraints.ConstraintsFactory;
import org.eclipse.papyrus.infra.constraints.SimpleConstraint;
import org.eclipse.papyrus.infra.constraints.ValueProperty;
import org.eclipse.papyrus.infra.constraints.environment.ConstraintType;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.LocalProfileIndex;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace.NameKind;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace.SwitchingSourceTraceHelper;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.AttributeOwner;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

class ImplicitUMLSourceTraceHelper
extends SwitchingSourceTraceHelper {
    private static final String UML_INSTANCE_OF = "org.eclipse.papyrus.uml.properties.constraints.UmlInstanceOfConstraint";
    private static final String HAS_STEREOTYPE = "org.eclipse.papyrus.uml.properties.constraints.HasStereotypeConstraint";
    private static final String PROPERTY_STEREOTYPE_NAME = "stereotypeName";
    private static final String PROPERTY_CLASS_NAME = "umlClassName";
    private static final URI UML_METAMODEL_URI = URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml");
    private final Set<String> constraintTypes = Set.of("org.eclipse.papyrus.uml.properties.constraints.UmlInstanceOfConstraint", "org.eclipse.papyrus.uml.properties.constraints.HasStereotypeConstraint");

    ImplicitUMLSourceTraceHelper() {
    }

    @Override
    public List<? extends EObject> getNestedPackages(EObject sourcePackage) {
        return sourcePackage instanceof Package ? ((Package)sourcePackage).getNestedPackages() : null;
    }

    @Override
    public List<? extends EObject> getClasses(EObject sourcePackage) {
        return sourcePackage instanceof Package ? this.getOwnedClasses((Package)sourcePackage) : null;
    }

    private List<Classifier> getOwnedClasses(Package package_) {
        return package_.getOwnedTypes().stream().filter(this::isClasslike).map(Classifier.class::cast).collect(Collectors.toList());
    }

    private boolean isClasslike(Type type) {
        return type instanceof Class || this.isComplexDataType(type);
    }

    private boolean isComplexDataType(Type type) {
        return type instanceof DataType && !(type instanceof PrimitiveType) && !(type instanceof Enumeration);
    }

    @Override
    protected EObject getOwningPackage(EObject sourceElement) {
        return sourceElement instanceof Package ? ((Package)sourceElement).getNestingPackage() : (sourceElement instanceof Element ? ((Element)sourceElement).getNearestPackage() : null);
    }

    @Override
    protected EObject getClass(EObject sourcePackage, DataContextElement contextElement) {
        return sourcePackage instanceof Package ? ((Package)sourcePackage).getOwnedType(contextElement.getName(), false, UMLPackage.Literals.CLASS, false) : null;
    }

    @Override
    public List<? extends EObject> getProperties(EObject sourceClass) {
        return sourceClass instanceof AttributeOwner ? ((AttributeOwner)sourceClass).getOwnedAttributes().stream().filter(Predicate.not(this::isExtensionEnd)).collect(Collectors.toList()) : null;
    }

    @Override
    public boolean isPropertyRedefinition(EObject sourceProperty) {
        return sourceProperty instanceof Property && !((Property)sourceProperty).getRedefinedProperties().isEmpty();
    }

    private boolean isExtensionEnd(Property property) {
        return UMLPackage.Literals.EXTENSION.isInstance((Object)property.getAssociation());
    }

    @Override
    public List<? extends EObject> getSuperclasses(EObject sourceClass) {
        return sourceClass instanceof Classifier ? ((Classifier)sourceClass).getGenerals().stream().filter(this::isClasslike).collect(Collectors.toList()) : null;
    }

    @Override
    public ConstraintDescriptor createInstanceOfConstraint(EObject sourceClass) {
        SimpleConstraint result = null;
        String constraintClassName = null;
        if (sourceClass instanceof Stereotype) {
            constraintClassName = HAS_STEREOTYPE;
        } else if (sourceClass instanceof Class) {
            constraintClassName = UML_INSTANCE_OF;
        } else if (sourceClass instanceof DataType) {
            constraintClassName = HAS_STEREOTYPE;
        }
        if (constraintClassName != null) {
            result = this.getConstraintType(constraintClassName).map(type -> {
                SimpleConstraint constraint = ConstraintsFactory.eINSTANCE.createSimpleConstraint();
                constraint.setConstraintType(type);
                this.setClassifier(constraint, (Classifier)sourceClass);
                return constraint;
            }).orElse(null);
        }
        return result;
    }

    @Override
    public boolean isInstanceOfConstraint(ConstraintDescriptor constraint) {
        return this.getConstraintType(constraint).map(ConstraintType::getConstraintClass).filter(this.constraintTypes::contains).isPresent();
    }

    @Override
    public EObject resolveInstanceOfConstraintClass(ConstraintDescriptor constraint) {
        EObject result = null;
        if (this.isInstanceOfConstraint(constraint)) {
            result = this.asSimpleConstraint(constraint).map(simple -> {
                switch (simple.getConstraintType().getConstraintClass()) {
                    case "org.eclipse.papyrus.uml.properties.constraints.UmlInstanceOfConstraint": {
                        return UMLPackage.eINSTANCE.getEClassifier(this.getValue((SimpleConstraint)simple, PROPERTY_CLASS_NAME));
                    }
                    case "org.eclipse.papyrus.uml.properties.constraints.HasStereotypeConstraint": {
                        String stereotypeName = this.getValue((SimpleConstraint)simple, PROPERTY_STEREOTYPE_NAME);
                        return LocalProfileIndex.getInstance((EObject)constraint).filter(__ -> stereotypeName != null).map(index -> index.getStereotype(stereotypeName, (EObject)simple)).orElse(null);
                    }
                }
                return null;
            }).orElse(null);
        }
        return result;
    }

    @Override
    public String getClassName(ConstraintDescriptor instanceOfConstraint) {
        return this.asSimpleConstraint(instanceOfConstraint).map(simple -> {
            switch (simple.getConstraintType().getConstraintClass()) {
                case "org.eclipse.papyrus.uml.properties.constraints.UmlInstanceOfConstraint": {
                    return this.getValue((SimpleConstraint)simple, PROPERTY_CLASS_NAME);
                }
                case "org.eclipse.papyrus.uml.properties.constraints.HasStereotypeConstraint": {
                    return this.getValue((SimpleConstraint)simple, PROPERTY_STEREOTYPE_NAME);
                }
            }
            return null;
        }).orElse(null);
    }

    @Override
    public ValueProperty getClassNameProperty(ConstraintDescriptor instanceOfConstraint) {
        return this.asSimpleConstraint(instanceOfConstraint).map(simple -> {
            switch (simple.getConstraintType().getConstraintClass()) {
                case "org.eclipse.papyrus.uml.properties.constraints.UmlInstanceOfConstraint": {
                    return this.getProperty((SimpleConstraint)simple, PROPERTY_CLASS_NAME);
                }
                case "org.eclipse.papyrus.uml.properties.constraints.HasStereotypeConstraint": {
                    return this.getProperty((SimpleConstraint)simple, PROPERTY_STEREOTYPE_NAME);
                }
            }
            return null;
        }).orElse(null);
    }

    @Override
    public Collection<? extends EObject> getValidConstraintSourceClasses(ConstraintDescriptor instanceOfConstraint, EObject sourceClass) {
        return this.asSimpleConstraint(instanceOfConstraint).map(simple -> {
            switch (simple.getConstraintType().getConstraintClass()) {
                case "org.eclipse.papyrus.uml.properties.constraints.UmlInstanceOfConstraint": {
                    return sourceClass instanceof Stereotype ? ((Stereotype)sourceClass).getAllExtendedMetaclasses() : List.of(sourceClass);
                }
            }
            return List.of(sourceClass);
        }).orElse(List.of(sourceClass));
    }

    @Override
    public IGenerator createGenerator(EObject sourceClass) {
        Classifier classifier;
        ProfileGenerator result = null;
        Profile profile = null;
        if (sourceClass instanceof Classifier && (classifier = (Classifier)sourceClass).getPackage() instanceof Profile) {
            profile = (Profile)classifier.getPackage();
        }
        if (profile != null) {
            Profile _profile = profile;
            result = new ProfileGenerator(_profile){
                {
                    this.setProfile(profile);
                }
            };
        }
        return result;
    }

    @Override
    protected EObject getProperty(EObject class_, org.eclipse.papyrus.infra.properties.contexts.Property contextProperty) {
        return class_ instanceof AttributeOwner ? ((AttributeOwner)class_).getOwnedAttribute(contextProperty.getName(), null) : null;
    }

    @Override
    public String getName(EObject sourceElement, NameKind kind) {
        String result = null;
        if (sourceElement instanceof NamedElement) {
            NamedElement namedElement = (NamedElement)sourceElement;
            switch (kind) {
                case QUALIFIED: {
                    result = UML2Util.getQualifiedText((EObject)namedElement, (UML2Util.QualifiedTextProvider)UMLUtil.QualifiedTextProvider.DEFAULT);
                    break;
                }
                case CONSTRAINT: {
                    if (namedElement instanceof Stereotype) {
                        result = UML2Util.getQualifiedText((EObject)namedElement, (UML2Util.QualifiedTextProvider)UMLUtil.QualifiedTextProvider.DEFAULT);
                        break;
                    }
                    result = namedElement.getName();
                    break;
                }
                default: {
                    result = namedElement.getName();
                }
            }
        }
        return result;
    }

    @Override
    public int getMultiplicity(EObject sourceProperty) {
        return sourceProperty instanceof MultiplicityElement ? ((MultiplicityElement)sourceProperty).upperBound() : DEFAULT_MULTIPLICITY;
    }

    @Override
    protected Switch<EObject> createConstraintsSwitch() {
        return new SwitchingSourceTraceHelper.ConstraintsDelegate(this){

            @Override
            protected EObject constraintSwitch(SimpleConstraint constraint, String constraintClass) {
                EObject result = null;
                switch (constraintClass) {
                    case "org.eclipse.papyrus.uml.properties.constraints.HasStereotypeConstraint": {
                        result = ImplicitUMLSourceTraceHelper.this.getStereotype(constraint);
                        break;
                    }
                    case "org.eclipse.papyrus.uml.properties.constraints.UmlInstanceOfConstraint": {
                        result = ImplicitUMLSourceTraceHelper.this.getUMLClass(constraint);
                    }
                }
                return result;
            }
        };
    }

    private EObject getStereotype(SimpleConstraint constraint) {
        EObject result = null;
        String stereotypeName = this.getValue(constraint, PROPERTY_STEREOTYPE_NAME);
        if (stereotypeName != null) {
            result = LocalProfileIndex.getInstance((EObject)constraint).map(index -> index.getStereotype(stereotypeName, (EObject)constraint)).orElse(null);
        }
        return result;
    }

    private EObject getUMLClass(SimpleConstraint constraint) {
        Type result = null;
        String className = this.getValue(constraint, PROPERTY_CLASS_NAME);
        if (className != null) {
            Package uml = (Package)UML2Util.load((ResourceSet)EMFHelper.getResourceSet((EObject)constraint), (URI)UML_METAMODEL_URI, (EClass)UMLPackage.Literals.PACKAGE);
            result = uml != null ? uml.getOwnedType(className) : null;
        }
        return result;
    }

    private void setClassifier(SimpleConstraint constraint, Classifier classifier) {
        switch (constraint.getConstraintType().getConstraintClass()) {
            case "org.eclipse.papyrus.uml.properties.constraints.HasStereotypeConstraint": {
                this.setValue(constraint, PROPERTY_STEREOTYPE_NAME, classifier.getQualifiedName());
                break;
            }
            default: {
                this.setValue(constraint, PROPERTY_CLASS_NAME, classifier.getName());
            }
        }
    }
}

