/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.nattable.utils;

import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.papyrus.eclipse.project.editors.project.PluginProjectEditor;
import org.eclipse.papyrus.toolsmiths.nattable.Activator;
import org.eclipse.papyrus.toolsmiths.nattable.messages.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TableConfigurationUtils {
    private static final String EXTENSION_POINT = "org.eclipse.papyrus.infra.nattable.configuration";
    private static final String CONFIGURATION = "configuration";
    private static final String FILE = "file";
    private static final String TYPE = "type";

    public static final IStatus registerTableConfiguration(IJavaProject project, String type, URI tableConfigurationURI) {
        PluginProjectEditor pEditor = null;
        try {
            pEditor = new PluginProjectEditor(project.getProject());
        }
        catch (IOException | ParserConfigurationException | CoreException | SAXException e) {
            Activator.log.error(e);
            return new Status(4, "org.eclipse.papyrus.toolsmiths.nattable", Messages.TableConfigurationUtils_PluginXMLCanBeCreated);
        }
        pEditor.init();
        if (pEditor.getMissingFiles().size() > 0) {
            pEditor.createFiles(pEditor.getMissingFiles());
            pEditor.init();
        }
        URI pathInThePlugin = null;
        int i = 2;
        while (i < tableConfigurationURI.segmentCount()) {
            pathInThePlugin = pathInThePlugin == null ? URI.createFileURI((String)tableConfigurationURI.segment(i)) : pathInThePlugin.appendSegment(tableConfigurationURI.segment(i));
            ++i;
        }
        String pluginPath = pathInThePlugin.path();
        if (TableConfigurationUtils.isAlreadyRegistered(pEditor, pluginPath, type)) {
            return Status.OK_STATUS;
        }
        List extensions = pEditor.getExtensions(EXTENSION_POINT);
        Element extensionPoint = extensions.size() > 0 ? (Element)extensions.get(extensions.size() - 1) : pEditor.addExtension(EXTENSION_POINT);
        Element configuration = pEditor.addChild(extensionPoint, CONFIGURATION);
        pEditor.setAttribute(configuration, FILE, pluginPath);
        pEditor.setAttribute(configuration, TYPE, type);
        pEditor.save();
        return Status.OK_STATUS;
    }

    private static final boolean isAlreadyRegistered(PluginProjectEditor pEditor, String filePath, String tableType) {
        List extensions = pEditor.getExtensions(EXTENSION_POINT);
        if (extensions == null) {
            return false;
        }
        for (Node currentExtention : extensions) {
            if (!TableConfigurationUtils.isAlreadyRegistered(currentExtention, filePath, tableType)) continue;
            return true;
        }
        return false;
    }

    private static final boolean isAlreadyRegistered(Node extension, String filePath, String tableType) {
        NodeList childNodes = extension.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node a = childNodes.item(i);
            if (a != null && a.getAttributes() != null) {
                NamedNodeMap attrs = a.getAttributes();
                Node valu1 = attrs.getNamedItem(FILE);
                Node values = attrs.getNamedItem(TYPE);
                if (filePath.equals(valu1.getNodeValue()) && tableType.equals(values.getNodeValue())) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }
}

