/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration.internal.migrators.atomic.stereotype;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.toolsmiths.profilemigration.MigratorProfileApplication;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure.StereotypeApplicationDescriptor;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure.StereotypeApplicationRegistry;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.utils.TreeNodeUtils;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.atomic.AbstractMigrator;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.atomic.stereotype.IMoveStereotypeMigrator;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.Activator;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.dialogs.MoveStereotypeDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class MoveStereotypeMigrator
extends AbstractMigrator
implements IMoveStereotypeMigrator {
    private EObject newContainer;
    private Stereotype stereotype;

    public MoveStereotypeMigrator(TreeNode treeNode) {
        super(treeNode);
    }

    public static boolean isValid(TreeNode node) {
        Object elt;
        return TreeNodeUtils.isMoveChange(node) && (elt = TreeNodeUtils.getMovedElement(node)) instanceof Stereotype && TreeNodeUtils.getMovedSourceContainer(node, MigratorProfileApplication.comparison) == MigratorProfileApplication.appliedProfile;
    }

    @Override
    public boolean isValid() {
        return MoveStereotypeMigrator.isValid(this.treeNode);
    }

    @Override
    public void migrationAction() {
        if (this.isDisplayDialogPreference() && this.newContainer instanceof Package) {
            Profile nearestProfile = this.getNearestProfile((Package)this.newContainer);
            Profile profile = this.getAppliedProfile(nearestProfile);
            List<StereotypeApplicationDescriptor> list = StereotypeApplicationRegistry.getStereotypeApplicationDescriptors(this.stereotype);
            if (profile == null && !list.isEmpty()) {
                MoveStereotypeDialog dialog = new MoveStereotypeDialog(Display.getDefault().getActiveShell(), this.stereotype, nearestProfile);
                dialog.open();
                if (dialog.isReapply()) {
                    MigratorProfileApplication.profiledModel.applyProfile(nearestProfile);
                    MigratorProfileApplication.newAppliedProfile.add(nearestProfile);
                } else {
                    for (StereotypeApplicationDescriptor descriptor : list) {
                        descriptor.getOwner().unapplyStereotype(descriptor.getStereotype());
                    }
                    StereotypeApplicationRegistry.stereotypeApplicationList.removeAll(list);
                }
            }
        }
    }

    private Profile getAppliedProfile(Profile profile) {
        return MigratorProfileApplication.profiledModel.getAppliedProfile(profile.getQualifiedName(), true);
    }

    private Profile getNearestProfile(Package package1) {
        if (package1 instanceof Profile) {
            return (Profile)package1;
        }
        if (package1.getOwner() instanceof Package) {
            return this.getNearestProfile((Package)package1.getOwner());
        }
        return null;
    }

    @Override
    public void initAttributes() {
        if (this.isValid()) {
            Object elt = TreeNodeUtils.getMovedElement(this.treeNode);
            this.newContainer = TreeNodeUtils.getMovedTargetContainer(this.treeNode);
            this.stereotype = (Stereotype)elt;
        }
    }

    private boolean isDisplayDialogPreference() {
        IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        return prefStore.getBoolean("StereotypeMove");
    }

    @Override
    public Stereotype getStereotype() {
        return this.stereotype;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public Element getTargetContainer() {
        return (Element)this.newContainer;
    }

    @Override
    public Element getSourceContainer() {
        return (Element)TreeNodeUtils.getMovedSourceContainer(this.treeNode, MigratorProfileApplication.comparison);
    }

    @Override
    public Element getMovedElement() {
        return this.getStereotype();
    }
}

