/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.common.codegen;

import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.codegen.util.ImportManager;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.papyrus.gmf.common.codegen.ImportAssistant;

public class ImportUtil
implements ImportAssistant {
    private final ImportManager myImportManager;
    private final String myPackageName;
    private final String myUnitName;
    private StringBuffer importStringBuffer;
    private int importInsertionPoint;

    public ImportUtil(String compilationUnitPackage, String compilationUnitName, IPackageFragmentRoot sourceRoot) {
        this(compilationUnitPackage, compilationUnitName);
        ICompilationUnit existingCU;
        if (sourceRoot != null && (existingCU = sourceRoot.getPackageFragment(compilationUnitPackage).getCompilationUnit(compilationUnitName + ".java")).exists()) {
            try {
                this.myImportManager.addCompilationUnitImports(existingCU.getSource());
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }

    public ImportUtil(String compilationUnitPackage, String compilationUnitName) {
        assert (compilationUnitName != null && compilationUnitName.trim().length() > 0);
        this.myImportManager = new ImportManager(compilationUnitPackage);
        this.myImportManager.addMasterImport(compilationUnitPackage == null ? "" : compilationUnitPackage, compilationUnitName);
        this.myPackageName = compilationUnitPackage;
        this.myUnitName = compilationUnitName;
    }

    @Override
    public void emitPackageStatement(StringBuffer stringBuffer) {
        if (this.myPackageName == null || this.myPackageName.trim().length() == 0) {
            return;
        }
        stringBuffer.append("\npackage ");
        stringBuffer.append(this.myPackageName);
        stringBuffer.append(';');
    }

    @Override
    public String getCompilationUnitName() {
        return this.myUnitName;
    }

    public void markImportLocation(StringBuffer stringBuffer, GenPackage genPackage) {
        this.markImportLocation(stringBuffer);
        this.myImportManager.addJavaLangImports(genPackage.getJavaLangConflicts());
    }

    @Override
    public void markImportLocation(StringBuffer stringBuffer) {
        this.importStringBuffer = stringBuffer;
        this.importInsertionPoint = stringBuffer.length();
        this.myImportManager.addCompilationUnitImports(stringBuffer.toString());
    }

    @Override
    public void emitSortedImports() {
        String NL = System.getProperties().getProperty("line.separator");
        StringBuffer importsBuf = new StringBuffer();
        String previousPackageName = null;
        for (String importName : this.myImportManager.getImports()) {
            int index = importName.lastIndexOf(".");
            if (index != -1) {
                String packageName = importName.substring(0, index);
                if (previousPackageName != null && !previousPackageName.equals(packageName)) {
                    importsBuf.append(NL);
                }
                previousPackageName = packageName;
            }
            importsBuf.append(NL + "import " + importName + ";");
        }
        this.importStringBuffer.insert(this.importInsertionPoint, importsBuf.toString());
    }

    @Override
    public String getImportedName(String qualifiedName) {
        if (qualifiedName.equals(CodeGenUtil.getSimpleClassName((String)qualifiedName))) {
            return qualifiedName;
        }
        int index = qualifiedName.indexOf("<");
        if (index >= 0) {
            String baseName = qualifiedName.substring(0, index);
            StringBuilder result = new StringBuilder(this.getImportedName(baseName));
            result.append("<");
            int start = ++index;
            int end = qualifiedName.lastIndexOf(">") + 1;
            while (index < end) {
                char character = qualifiedName.charAt(index);
                switch (character) {
                    case ' ': 
                    case '&': 
                    case ',': 
                    case '<': 
                    case '>': {
                        if (start != index) {
                            String segment = qualifiedName.substring(start, index);
                            result.append(this.getImportedName(segment));
                        }
                        result.append(character);
                        start = index + 1;
                        break;
                    }
                }
                ++index;
            }
            return result.toString();
        }
        index = qualifiedName.indexOf("$");
        this.myImportManager.addImport(index == -1 ? qualifiedName : qualifiedName.substring(0, index));
        return this.myImportManager.getImportedName(qualifiedName);
    }

    @Override
    public void addImport(String qualifiedName) {
        this.myImportManager.addImport(qualifiedName);
    }

    @Override
    public void registerInnerClass(String innerClassName) {
        this.myImportManager.addPseudoImport(innerClassName);
    }

    public void addImport(String packageName, String shortName) {
        this.myImportManager.addImport(packageName, shortName);
    }
}

