/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.sort;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NamedStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestyleFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.StringValueStyle;
import org.eclipse.papyrus.infra.nattable.sort.ColumnSortUtils;
import org.eclipse.papyrus.infra.nattable.sort.copy.NatTableComparatorChooser;

public class SaveSortedColumnCommand
extends AbstractTransactionalCommand {
    private final INattableModelManager manager;
    private final NatTableComparatorChooser<?> chooser;
    private final List<Integer> previousSortedColumns;

    public SaveSortedColumnCommand(TransactionalEditingDomain domain, INattableModelManager manager, NatTableComparatorChooser<?> chooser, List<Integer> previousSortedColumns) {
        super(domain, "Save Sorted Columns", null);
        this.manager = manager;
        this.chooser = chooser;
        this.previousSortedColumns = previousSortedColumns;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        NamedStyle style;
        Object column;
        int columnIndex;
        List<Integer> currentSortedColumns = this.chooser.getSortingColumns();
        ArrayList<Integer> columnsToRemove = new ArrayList<Integer>(this.previousSortedColumns);
        columnsToRemove.removeAll(currentSortedColumns);
        Iterator<Object> iterator = columnsToRemove.iterator();
        while (iterator.hasNext()) {
            columnIndex = (Integer)iterator.next();
            column = this.manager.getColumnElement(columnIndex);
            if (!(column instanceof IAxis) || (style = ((IAxis)column).getNamedStyle(NattablestylePackage.eINSTANCE.getStringValueStyle(), "sort")) == null) continue;
            ((IAxis)column).getStyles().remove((Object)style);
        }
        iterator = currentSortedColumns.iterator();
        while (iterator.hasNext()) {
            columnIndex = (Integer)iterator.next();
            column = this.manager.getColumnElement(columnIndex);
            if (!(column instanceof IAxis)) continue;
            style = (StringValueStyle)((IAxis)column).getNamedStyle(NattablestylePackage.eINSTANCE.getStringValueStyle(), "sort");
            if (style == null) {
                style = NattablestyleFactory.eINSTANCE.createStringValueStyle();
                style.setName("sort");
                ((IAxis)column).getStyles().add((Object)style);
            }
            style.setStringValue(ColumnSortUtils.buildSortStringValue(this.chooser, columnIndex));
        }
        return CommandResult.newOKCommandResult();
    }
}

