/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.newchild.internal.checkers;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.Menu;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

final class NewChildMenuPluginXMLValidator {
    static final String CATEGORY = "creation_menus";
    private final IFile modelFile;

    NewChildMenuPluginXMLValidator(IFile modelFile) {
        this.modelFile = modelFile;
    }

    Optional<Element> matchExtension(Element element, String point, Menu model) {
        switch (point) {
            case "org.eclipse.papyrus.infra.newchild": {
                NodeList children = element.getElementsByTagName("menuCreationModel");
                int i = 0;
                while (i < children.getLength()) {
                    Element menuCreationModel = (Element)children.item(i);
                    if (this.matchMenuCreationModel(menuCreationModel, model)) {
                        return Optional.of(menuCreationModel);
                    }
                    ++i;
                }
                break;
            }
        }
        return Optional.empty();
    }

    boolean matchMenuCreationModel(Element element, Menu model) {
        String path = element.getAttribute("model");
        return Objects.equals(path, this.modelFile.getProjectRelativePath().toString());
    }

    int problemID(String point, Menu menu) {
        switch (point) {
            case "org.eclipse.papyrus.infra.newchild": {
                return 16715840;
            }
        }
        return -1;
    }
}

