/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cbi.p2repo.aggregator.AggregatorFactory;
import org.eclipse.cbi.p2repo.aggregator.IAggregatorConstants;
import org.eclipse.cbi.p2repo.aggregator.InstallableUnitType;
import org.eclipse.cbi.p2repo.aggregator.Status;
import org.eclipse.cbi.p2repo.aggregator.StatusCode;
import org.eclipse.cbi.p2repo.p2.InstallableUnit;
import org.eclipse.cbi.p2repo.util.StringUtils;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.TranslationSupport;
import org.eclipse.equinox.internal.p2.metadata.index.CapabilityIndex;
import org.eclipse.equinox.internal.p2.metadata.index.IdIndex;
import org.eclipse.equinox.internal.p2.metadata.index.IndexProvider;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.KeyWithLocale;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.index.IIndex;
import org.eclipse.equinox.p2.query.IQueryable;

public class InstallableUnitUtils {
    public static void appendIdentifier(StringBuilder bld, IInstallableUnit iu) {
        InstallableUnitType riuType = InstallableUnitUtils.getType(iu);
        bld.append(riuType.toString());
        bld.append('(');
        bld.append(iu.getId());
        Version v = iu.getVersion();
        if (v != null && !v.equals(Version.emptyVersion)) {
            bld.append(' ');
            bld.append(v);
        }
        bld.append(')');
    }

    public static void appendIdentifier(StringBuilder bld, IRequirement req) {
        if (req instanceof RequiredCapability) {
            RequiredCapability rc = (RequiredCapability)req;
            String ns = rc.getNamespace();
            if ("osgi.bundle".equals(ns)) {
                bld.append("Bundle(");
            } else if ("java.package".equals(ns)) {
                bld.append("JavaPackage(");
            } else {
                bld.append("InstallableUnit(");
            }
            bld.append(rc.getName());
            VersionRange range = rc.getRange();
            if (range != null && !VersionRange.emptyRange.equals((Object)range)) {
                bld.append(' ');
                bld.append(range);
            }
            bld.append(')');
        } else {
            bld.append(req.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Status getStatus(InstallableUnit iu) {
        InstallableUnit installableUnit = iu;
        synchronized (installableUnit) {
            return StringUtils.trimmedOrNull((String)iu.getId()) != null ? AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK) : AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN);
        }
    }

    public static InstallableUnitType getType(IInstallableUnit iu) {
        if ("true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.category"))) {
            return InstallableUnitType.CATEGORY;
        }
        if (iu.getId().endsWith(".feature.group")) {
            return InstallableUnitType.FEATURE;
        }
        if ("true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.group"))) {
            return InstallableUnitType.PRODUCT;
        }
        if (InstallableUnitUtils.isOSGiFragment(iu)) {
            return InstallableUnitType.FRAGMENT;
        }
        if (InstallableUnitUtils.isOSGiBundle(iu)) {
            return InstallableUnitType.BUNDLE;
        }
        return InstallableUnitType.OTHER;
    }

    private static boolean isOSGiBundle(IInstallableUnit iu) {
        for (IProvidedCapability rc : iu.getProvidedCapabilities()) {
            if (!"org.eclipse.equinox.p2.eclipse.type".equals(rc.getNamespace()) || !IAggregatorConstants.CAPABILITY_TYPE_BUNDLE.equals(rc.getName()) && !"source".equals(rc.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isOSGiFragment(IInstallableUnit iu) {
        for (IProvidedCapability rc : iu.getProvidedCapabilities()) {
            if (!"osgi.fragment".equals(rc.getNamespace())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSourceBundle(IInstallableUnit iu) {
        for (IProvidedCapability rc : iu.getProvidedCapabilities()) {
            if (!"org.eclipse.equinox.p2.eclipse.type".equals(rc.getNamespace()) || !"source".equals(rc.getName())) continue;
            return true;
        }
        return false;
    }

    public static IQueryable<IInstallableUnit> getIndex(Collection<? extends IInstallableUnit> ius) {
        return new InstallableUnitIndex(ius);
    }

    private static class InstallableUnitIndex
    extends IndexProvider<IInstallableUnit> {
        private final List<IInstallableUnit> dataSet;
        private final IIndex<IInstallableUnit> capabilityIndex;
        private final IIndex<IInstallableUnit> idIndex;
        private final TranslationSupport translationSupport;

        public InstallableUnitIndex(Collection<? extends IInstallableUnit> ius) {
            this.dataSet = new ArrayList<IInstallableUnit>(ius);
            this.capabilityIndex = new CapabilityIndex(this.dataSet.iterator());
            this.idIndex = new IdIndex(this.dataSet.iterator());
            this.translationSupport = new TranslationSupport((IQueryable)this);
        }

        public Iterator<IInstallableUnit> everything() {
            return this.dataSet.iterator();
        }

        public IIndex<IInstallableUnit> getIndex(String memberName) {
            if ("providedCapabilities".equals(memberName)) {
                return this.capabilityIndex;
            }
            if ("id".equals(memberName)) {
                return this.idIndex;
            }
            return null;
        }

        public Object getManagedProperty(Object client, String memberName, Object key) {
            if (client instanceof IInstallableUnit && "translatedProperties".equals(memberName)) {
                IInstallableUnit iu = (IInstallableUnit)client;
                return key instanceof KeyWithLocale ? this.translationSupport.getIUProperty(iu, (KeyWithLocale)key) : this.translationSupport.getIUProperty(iu, key.toString());
            }
            return null;
        }
    }
}

