/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils.rules;

import org.eclipse.papyrus.junit.utils.JUnitUtils;
import org.eclipse.papyrus.junit.utils.rules.UIThread;
import org.eclipse.swt.widgets.Display;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class UIThreadRule
implements TestRule {
    private final boolean requireAnnotation;

    public UIThreadRule() {
        this(false);
    }

    public UIThreadRule(boolean requireAnnotation) {
        this.requireAnnotation = requireAnnotation;
    }

    public Statement apply(final Statement base, Description description) {
        if (!this.requiresUIThread(description)) {
            return base;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                final Throwable[] caught = new Throwable[1];
                Runnable runTest = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            base.evaluate();
                        }
                        catch (Throwable t) {
                            caught[0] = t;
                        }
                    }
                };
                if (Display.getCurrent() != null) {
                    runTest.run();
                } else {
                    Display.getDefault().syncExec(runTest);
                }
                if (caught[0] != null) {
                    throw caught[0];
                }
            }
        };
    }

    private boolean requiresUIThread(Description description) {
        return !this.requireAnnotation || JUnitUtils.getAnnotation(description, UIThread.class) != null;
    }
}

