/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.validators;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.customization.properties.generation.generators.EcoreGenerator;
import org.eclipse.papyrus.customization.properties.generation.generators.IGenerator;
import org.eclipse.papyrus.customization.properties.generation.generators.ProfileGenerator;
import org.eclipse.papyrus.customization.properties.generation.messages.Messages;
import org.eclipse.papyrus.customization.properties.generation.validators.AbstractValidator;

public class SourceValidator
extends AbstractValidator {
    protected IGenerator generator;

    public SourceValidator(IGenerator generator) {
        this.generator = generator;
    }

    public IStatus validate(Object value) {
        if (value instanceof String) {
            String s = (String)value;
            if (!s.equals("")) {
                if (this.generator instanceof EcoreGenerator) {
                    if (!s.endsWith("ecore")) {
                        return this.warning(Messages.SourceValidator_2);
                    }
                } else if (this.generator instanceof ProfileGenerator && !s.endsWith("uml")) {
                    return this.warning(Messages.SourceValidator_4);
                }
                IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IFile file = null;
                try {
                    Path path = new Path(s);
                    file = myWorkspaceRoot.getFile((IPath)path);
                }
                catch (IllegalArgumentException ex) {
                    return this.error(ex.getMessage());
                }
                if (!file.exists()) {
                    return this.error(Messages.SourceValidator_5);
                }
            } else {
                return this.error(Messages.SourceValidator_6);
            }
            return Status.OK_STATUS;
        }
        return this.error(Messages.SourceValidator_7);
    }
}

