/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.quickfix;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.tools.util.TriFunction;
import org.eclipse.papyrus.infra.tools.util.Try;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.AbstractPapyrusWorkbenchMarkerResolution;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.CommonMarkerResolutionUtils;

public class SimpleModelEditMarkerResolution<T extends EObject>
extends AbstractPapyrusWorkbenchMarkerResolution {
    private final String label;
    private final String description;
    private final Class<T> type;
    private final TriFunction<? super EditingDomain, ? super T, ? super IMarker, ? extends Command> commandFunction;
    private boolean canMultiFix = true;

    protected SimpleModelEditMarkerResolution(int problemID, String label, String description, Class<T> type, TriFunction<? super EditingDomain, ? super T, ? super IMarker, ? extends Command> commandFunction) {
        super(problemID);
        this.label = label;
        this.description = description;
        this.type = type;
        this.commandFunction = commandFunction;
    }

    public static <T extends EObject> SimpleModelEditMarkerResolution<T> create(int problemID, String label, String description, Class<T> type, TriFunction<? super EditingDomain, ? super T, ? super IMarker, ? extends Command> commandFunction) {
        return new SimpleModelEditMarkerResolution<T>(problemID, label, description, type, commandFunction);
    }

    public static <T extends EObject> SimpleModelEditMarkerResolution<T> create(int problemID, String label, String description, Class<T> type, BiFunction<? super EditingDomain, ? super T, ? extends Command> commandFunction) {
        return new SimpleModelEditMarkerResolution<T>(problemID, label, description, type, (domain, object, __) -> (Command)commandFunction.apply((EditingDomain)domain, (Object)object));
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public void run(IMarker marker) {
        this.run(new IMarker[]{marker}, (IProgressMonitor)new NullProgressMonitor());
    }

    public void run(IMarker[] markers, IProgressMonitor monitor) {
        Multimap<Try<EditingDomain>, IMarker> openDomains = this.getOpenEditingDomains(markers);
        if (openDomains.keySet().stream().anyMatch(Try::isFailure)) {
            if (monitor != null) {
                monitor.setCanceled(true);
            }
            return;
        }
        final SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * openDomains.size()));
        try {
            for (Map.Entry next : openDomains.asMap().entrySet()) {
                Try openDomain = (Try)next.getKey();
                Collection partition = (Collection)next.getValue();
                EditingDomain domain = openDomain.toOptional().orElseGet(this::createEditingDomain);
                QuickFixLoadedResourcesAdapter loadedResourceAdapter = new QuickFixLoadedResourcesAdapter(domain);
                try {
                    CompoundCommand fixCommand = new CompoundCommand();
                    for (IMarker marker : partition) {
                        CommonMarkerResolutionUtils.getModelObject(marker, this.type, domain).ifPresent(object -> {
                            Command command = (Command)this.commandFunction.apply((Object)domain, object, (Object)marker);
                            if (command != null) {
                                fixCommand.append((Command)new CommandWrapper(command){

                                    public void execute() {
                                        super.execute();
                                        sub.worked(1);
                                    }
                                });
                            }
                            sub.worked(1);
                        });
                    }
                    Command command = fixCommand.unwrap();
                    if (command.canExecute()) {
                        domain.getCommandStack().execute(command);
                    } else {
                        sub.worked(partition.size());
                    }
                }
                catch (Throwable throwable) {
                    loadedResourceAdapter.getTarget().eAdapters().remove((Object)loadedResourceAdapter);
                    openDomain.flatMap(CommonMarkerResolutionUtils::getEditor).ifPresent(editor -> {
                        boolean bl = editor.getSite().getPage().saveEditor(editor, false);
                    });
                    throw throwable;
                }
                loadedResourceAdapter.getTarget().eAdapters().remove((Object)loadedResourceAdapter);
                openDomain.flatMap(CommonMarkerResolutionUtils::getEditor).ifPresent(editor -> {
                    boolean bl = editor.getSite().getPage().saveEditor(editor, false);
                });
            }
        }
        finally {
            sub.done();
        }
    }

    private Multimap<Try<EditingDomain>, IMarker> getOpenEditingDomains(IMarker[] markers) {
        ImmutableListMultimap partitions = Multimaps.index(Arrays.asList(markers), IMarker::getResource);
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (IResource next : partitions.keySet()) {
            List nextPartition = partitions.get((Object)next);
            IMarker marker = (IMarker)nextPartition.get(0);
            result.putAll(CommonMarkerResolutionUtils.getOpenEditingDomain(marker), (Iterable)nextPartition);
        }
        return result.build();
    }

    private EditingDomain createEditingDomain() {
        return new AdapterFactoryEditingDomain((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), (CommandStack)new BasicCommandStack());
    }

    public SimpleModelEditMarkerResolution<T> disableMultiFix() {
        this.canMultiFix = false;
        return this;
    }

    public boolean canMultiFix() {
        return this.canMultiFix;
    }

    @Override
    protected Stream<IMarker> findSimilarMarkers(IMarker[] markers) {
        return this.canMultiFix() ? super.findSimilarMarkers(markers) : Stream.empty();
    }

    private final class QuickFixLoadedResourcesAdapter
    extends AdapterImpl {
        private final List<Resource> loadedByQuickFix = new ArrayList<Resource>();

        QuickFixLoadedResourcesAdapter(EditingDomain domain) {
            domain.getResourceSet().eAdapters().add((Object)this);
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeatureID(ResourceSet.class) == 0) {
                switch (msg.getEventType()) {
                    case 3: {
                        this.handleAdded((Resource)msg.getNewValue());
                        break;
                    }
                    case 5: {
                        ((Collection)msg.getNewValue()).stream().map(Resource.class::cast).forEach(this::handleAdded);
                    }
                }
            }
        }

        public void unsetTarget(Notifier oldTarget) {
            this.loadedByQuickFix.forEach(this::saveAndUnload);
            this.loadedByQuickFix.clear();
            super.unsetTarget(oldTarget);
        }

        private void handleAdded(Resource resource) {
            this.loadedByQuickFix.add(resource);
            resource.setTrackingModification(true);
        }

        private void saveAndUnload(Resource resource) {
            resource.getResourceSet().getResources().remove((Object)resource);
            try {
                try {
                    if (resource.isModified()) {
                        resource.save(Map.of("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER"));
                    }
                }
                catch (IOException e) {
                    Activator.log.error(NLS.bind((String)Messages.SimpleModelEditMarkerResolution_0, (Object)resource.getURI(), (Object)SimpleModelEditMarkerResolution.this.getLabel()), (Throwable)e);
                    resource.unload();
                }
            }
            finally {
                resource.unload();
            }
        }
    }
}

