/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.quickfix;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.customization.properties.generation.generators.GeneratorHelper;
import org.eclipse.papyrus.customization.properties.generation.generators.IGenerator;
import org.eclipse.papyrus.customization.properties.generation.layout.ILayoutGenerator;
import org.eclipse.papyrus.infra.constraints.ConstraintDescriptor;
import org.eclipse.papyrus.infra.properties.contexts.Annotatable;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.ContextsFactory;
import org.eclipse.papyrus.infra.properties.contexts.ContextsPackage;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.contexts.DataContextPackage;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.infra.properties.contexts.Tab;
import org.eclipse.papyrus.infra.properties.contexts.UnknownProperty;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.contexts.util.ContextAnnotations;
import org.eclipse.papyrus.infra.properties.ui.CompositeWidget;
import org.eclipse.papyrus.infra.properties.ui.PropertyEditor;
import org.eclipse.papyrus.infra.properties.ui.Widget;
import org.eclipse.papyrus.infra.properties.ui.util.PropertiesUtil;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;
import org.eclipse.papyrus.infra.tools.util.Iterators2;
import org.eclipse.papyrus.infra.tools.util.TriFunction;
import org.eclipse.papyrus.infra.tools.util.Try;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.CommonMarkerResolutionUtils;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.SimpleModelEditMarkerResolution;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.Activator;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace.ComposedSourceTraceHelper;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace.SourceTraceHelper;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.util.PropertiesCache;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.util.PropertyTypeHelper;
import org.eclipse.ui.IMarkerResolution;

abstract class AbstractModelEditResolutionFactory {
    private final int problemID;
    private final SourceTraceHelper traceHelper;
    private final ThreadLocal<IMarker> marker = new ThreadLocal();

    AbstractModelEditResolutionFactory(int problemID) {
        this.problemID = problemID;
        this.traceHelper = new ComposedSourceTraceHelper();
    }

    protected final IMarker getMarker() {
        return this.marker.get();
    }

    protected final int getProblemID() {
        return this.problemID;
    }

    protected final SourceTraceHelper getTraceHelper() {
        return this.traceHelper;
    }

    public Iterable<IMarkerResolution> createResolutions(IMarker marker) {
        return this.withMarker(marker, this::createResolutions);
    }

    private <T> T withMarker(IMarker marker, Supplier<T> computation) {
        this.marker.set(marker);
        try {
            T t = computation.get();
            return t;
        }
        finally {
            this.marker.remove();
        }
    }

    protected abstract Iterable<IMarkerResolution> createResolutions();

    protected <T extends EObject> IMarkerResolution createResolution(String label, String description, Class<T> type, BiFunction<? super EditingDomain, ? super T, ? extends Command> command) {
        return SimpleModelEditMarkerResolution.create((int)this.getProblemID(), (String)label, (String)description, type, this.withMarker(command));
    }

    private <T extends EObject> TriFunction<EditingDomain, T, IMarker, Command> withMarker(BiFunction<? super EditingDomain, ? super T, ? extends Command> command) {
        return (domain, object, marker) -> this.withMarker((IMarker)marker, () -> (Command)command.apply((EditingDomain)domain, (Object)object));
    }

    @SafeVarargs
    protected final <T extends EObject> TriFunction<EditingDomain, T, IMarker, Command> compose(TriFunction<? super EditingDomain, ? super T, ? super IMarker, ? extends Command> ... commands) {
        return (domain, object, marker) -> {
            CompoundCommand result = new CompoundCommand();
            TriFunction[] triFunctionArray2 = commands;
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                TriFunction commandFunction = triFunctionArray2[n2];
                Command command = (Command)commandFunction.apply(domain, object, marker);
                if (command != null) {
                    result.append(command);
                }
                ++n2;
            }
            return result.unwrap();
        };
    }

    protected Iterator<CompositeWidget> widgeterator(Section section) {
        return this.widgeterator(section, CompositeWidget.class);
    }

    protected <T extends Widget> Iterator<T> widgeterator(Section section, Class<? extends T> type) {
        CompositeWidget composite = section.getWidget();
        if (composite == null || composite.eIsProxy()) {
            return Collections.emptyIterator();
        }
        return Iterators2.autoPrune((TreeIterator)Iterators2.filter((TreeIterator)EcoreUtil.getAllContents(Set.of(composite)), type), Predicate.not(CompositeWidget.class::isInstance));
    }

    protected Context getContext(DataContextElement element) {
        EObject result = EcoreUtil.getRootContainer((EObject)element);
        return result instanceof Context ? (Context)result : null;
    }

    protected int getElementMultiplicity(Section section) {
        int result = SourceTraceHelper.DEFAULT_MULTIPLICITY;
        for (View view : section.getViews()) {
            result = view.getElementMultiplicity();
            if (result != SourceTraceHelper.DEFAULT_MULTIPLICITY) break;
        }
        return result;
    }

    protected PropertyEditor getPropertyEditor(Section section, Property property) {
        return (PropertyEditor)Iterators.find(this.widgeterator(section, PropertyEditor.class), pe -> this.isPropertyEditorFor((PropertyEditor)pe, property), null);
    }

    protected PropertyEditor getPropertyEditor(Section section, DataContextElement element, Property property) {
        return (PropertyEditor)Iterators.find(this.widgeterator(section, PropertyEditor.class), pe -> this.isPropertyEditorFor((PropertyEditor)pe, element, property), null);
    }

    protected boolean isPropertyEditorFor(PropertyEditor propertyEditor, Property property) {
        boolean result;
        boolean bl = result = propertyEditor.getProperty() == property;
        if (!result) {
            String qname = this.getQualifiedName(property);
            UnknownProperty unknown = propertyEditor.getUnresolvedProperty();
            result = unknown != null && qname.equals(unknown.getName());
        }
        return result;
    }

    protected boolean isPropertyEditorFor(PropertyEditor propertyEditor, DataContextElement element, Property property) {
        boolean result;
        boolean bl = result = propertyEditor.getProperty() == property;
        if (!result) {
            String qname = this.getQualifiedName(element, property);
            UnknownProperty unknown = propertyEditor.getUnresolvedProperty();
            result = unknown != null && qname.equals(unknown.getName());
        }
        return result;
    }

    protected final String getQualifiedName(DataContextElement element) {
        StringBuilder result = new StringBuilder();
        this.collectQualifiedName(element, result);
        return result.toString();
    }

    private void collectQualifiedName(DataContextElement element, StringBuilder name) {
        if (element.getPackage() != null) {
            this.collectQualifiedName((DataContextElement)element.getPackage(), name);
            name.append(':');
        }
        name.append(element.getName());
    }

    protected final String getQualifiedName(Property property) {
        StringBuilder result = new StringBuilder();
        this.collectQualifiedName(property, result);
        return result.toString();
    }

    private void collectQualifiedName(Property property, StringBuilder name) {
        if (property.getContextElement() != null) {
            this.collectQualifiedName(property.getContextElement(), name);
            name.append(':');
        }
        name.append(property.getName());
    }

    protected final String getQualifiedName(DataContextElement element, Property property) {
        StringBuilder result = new StringBuilder();
        this.collectQualifiedName(element, result);
        result.append(':');
        result.append(property.getName());
        return result.toString();
    }

    protected Property createDataContextProperty(EditingDomain domain, EObject sourceProperty) {
        Property result = ContextsFactory.eINSTANCE.createProperty();
        ContextAnnotations.setSourceModel((Annotatable)result, (EObject)sourceProperty);
        String name = this.getTraceHelper().getName(sourceProperty);
        result.setName(name);
        result.setLabel(PropertiesUtil.getLabel((String)name));
        result.setMultiplicity(this.getTraceHelper().getMultiplicity(sourceProperty));
        result.setType(PropertyTypeHelper.getInstance(result).getPropertyType(sourceProperty));
        return result;
    }

    protected DataContextPackage createDataContextPackage(EditingDomain domain, EObject sourcePackage) {
        DataContextPackage result = ContextsFactory.eINSTANCE.createDataContextPackage();
        ContextAnnotations.setSourceModel((Annotatable)result, (EObject)sourcePackage);
        String name = this.getTraceHelper().getName(sourcePackage);
        result.setName(name);
        this.getTraceHelper().getNestedPackages(sourcePackage).stream().map(nested -> this.createDataContextPackage(domain, (EObject)nested)).forEach(arg_0 -> result.getElements().add(arg_0));
        this.getTraceHelper().getClasses(sourcePackage).stream().map(sourceClass -> this.createDataContextElement(domain, (EObject)sourceClass)).forEach(arg_0 -> result.getElements().add(arg_0));
        return result;
    }

    protected DataContextElement createDataContextElement(EditingDomain domain, EObject sourceClass) {
        DataContextElement result = ContextsFactory.eINSTANCE.createDataContextElement();
        ContextAnnotations.setSourceModel((Annotatable)result, (EObject)sourceClass);
        String name = this.getTraceHelper().getName(sourceClass);
        result.setName(name);
        this.getTraceHelper().getProperties(sourceClass).stream().map(sourceProperty -> this.createDataContextProperty(domain, (EObject)sourceProperty)).forEach(arg_0 -> result.getProperties().add(arg_0));
        CommonMarkerResolutionUtils.getModelObject((IMarker)this.getMarker(), DataContextPackage.class, (EditingDomain)domain).ifPresent(package_ -> {
            PropertiesCache cache = PropertiesCache.getInstance((Notifier)package_);
            cache.getSuperclasses(sourceClass).stream().map(superclass -> cache.getDataContextElement((DataContextPackage)package_, (EObject)superclass)).flatMap(Optional::stream).forEach(arg_0 -> result.getSupertypes().add(arg_0));
        });
        return result;
    }

    protected Optional<Class<? extends ILayoutGenerator>> getLayoutGeneratorClass() {
        return Optional.ofNullable(this.getMarker().getAttribute("layout_generator", null)).map(URI::createURI).filter(ClassLoaderHelper::isClassURI).map(ClassLoaderHelper::loadClass).map(loaded -> (Class)loaded.orElse(null)).filter(ILayoutGenerator.class::isAssignableFrom).map(c -> c.asSubclass(ILayoutGenerator.class));
    }

    protected ILayoutGenerator instantiateLayout(Class<? extends ILayoutGenerator> layoutClass) {
        return (ILayoutGenerator)Try.call(() -> (ILayoutGenerator)layoutClass.getConstructor(new Class[0]).newInstance(new Object[0])).orElseAccept((reason, exception) -> Activator.log.error("Failed to instantiate layout generator.", exception));
    }

    protected View createView(Context context, DataContextElement element, int multiplicity) {
        EObject sourceClass = ContextAnnotations.getSourceModel((Annotatable)element, (EObject)context);
        View result = ContextsFactory.eINSTANCE.createView();
        ContextAnnotations.setSourceModel((Annotatable)result, (EObject)sourceClass);
        String namePattern = multiplicity == 1 ? Messages.AbstractModelEditResolutionFactory_1 : Messages.AbstractModelEditResolutionFactory_2;
        result.setName(NLS.bind((String)namePattern, (Object)element.getName()));
        result.setElementMultiplicity(multiplicity);
        result.setAutomaticContext(true);
        result.getDatacontexts().add((Object)element);
        ConstraintDescriptor constraint = this.getTraceHelper().createInstanceOfConstraint(sourceClass);
        constraint.setName(NLS.bind((String)Messages.AbstractModelEditResolutionFactory_3, (Object)result.getName().replaceAll("\\s+", "")));
        result.getConstraints().add((Object)constraint);
        return result;
    }

    protected Command createLayoutCommand(EditingDomain domain, ILayoutGenerator layout, Context context, DataContextElement element, View view) {
        return this.createLayoutCommand(domain, layout, context, element, view, null);
    }

    protected Command createLayoutCommand(EditingDomain domain, ILayoutGenerator layout, final Context context, DataContextElement element, final View view, final Collection<? extends Property> properties) {
        CompoundCommand result = new CompoundCommand();
        result.append(AddCommand.create((EditingDomain)domain, (Object)context, (Object)ContextsPackage.Literals.CONTEXT__VIEWS, (Object)view));
        EObject sourceClass = ContextAnnotations.getSourceModel((Annotatable)element, (EObject)context);
        IGenerator generator = this.getTraceHelper().createGenerator(sourceClass);
        final GeneratorHelper helper = new GeneratorHelper(generator, layout);
        final Tab tab = (Tab)Iterables.getFirst((Iterable)context.getTabs(), null);
        if (tab == null) {
            return UnexecutableCommand.INSTANCE;
        }
        result.append((Command)new ChangeCommand((Notifier)context){
            private List<Section> generatedSections;

            protected void doExecute() {
                this.generatedSections = helper.generateLayout(context, tab, view, (property, multiplicity) -> multiplicity == 1 && (properties == null || properties.contains(property)));
            }

            public Collection<?> getAffectedObjects() {
                ArrayList<Context> result = new ArrayList<Context>();
                result.add(context);
                if (this.generatedSections != null) {
                    this.generatedSections.stream().map(Section::getWidget).filter(Objects::nonNull).forEach(result::add);
                }
                return result;
            }
        });
        return result.unwrap();
    }
}

