/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.codegen.gmfgen;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ViewmapLayoutType implements Enumerator
{
    UNKNOWN_LITERAL(0, "UNKNOWN", "UNKNOWN"),
    XY_LAYOUT_LITERAL(1, "XY_LAYOUT", "XY_LAYOUT"),
    FLOW_LAYOUT_LITERAL(2, "FLOW_LAYOUT", "FLOW_LAYOUT"),
    TOOLBAR_LAYOUT_LITERAL(3, "TOOLBAR_LAYOUT", "TOOLBAR_LAYOUT");

    public static final int UNKNOWN = 0;
    public static final int XY_LAYOUT = 1;
    public static final int FLOW_LAYOUT = 2;
    public static final int TOOLBAR_LAYOUT = 3;
    private static final ViewmapLayoutType[] VALUES_ARRAY;
    public static final List<ViewmapLayoutType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ViewmapLayoutType[]{UNKNOWN_LITERAL, XY_LAYOUT_LITERAL, FLOW_LAYOUT_LITERAL, TOOLBAR_LAYOUT_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ViewmapLayoutType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ViewmapLayoutType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ViewmapLayoutType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ViewmapLayoutType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ViewmapLayoutType get(int value) {
        switch (value) {
            case 0: {
                return UNKNOWN_LITERAL;
            }
            case 1: {
                return XY_LAYOUT_LITERAL;
            }
            case 2: {
                return FLOW_LAYOUT_LITERAL;
            }
            case 3: {
                return TOOLBAR_LAYOUT_LITERAL;
            }
        }
        return null;
    }

    private ViewmapLayoutType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

