/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.textedit.xtext.internal.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.papyrus.infra.textedit.xtext.Activator;

public class TextUndoRedoCommandWrapper
extends AbstractCommand {
    private IUndoableOperation operation;

    public TextUndoRedoCommandWrapper(IUndoableOperation operation) {
        super("Wrapped Papyrus Text Edit Operation");
        this.operation = operation;
    }

    public void execute() {
    }

    public boolean canExecute() {
        return true;
    }

    protected boolean prepare() {
        return true;
    }

    public void undo() {
        try {
            if (this.operation != null) {
                this.getOperationHistory().undoOperation(this.operation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
        }
        catch (ExecutionException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void redo() {
        try {
            if (this.operation != null) {
                this.getOperationHistory().redoOperation(this.operation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
        }
        catch (ExecutionException e) {
            Activator.log.error((Throwable)e);
        }
    }

    private IOperationHistory getOperationHistory() {
        return OperationHistoryFactory.getOperationHistory();
    }
}

