/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.nattableconfiguration.wizards;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.customization.nattableconfiguration.Activator;
import org.eclipse.papyrus.customization.nattableconfiguration.helper.TableConfigurationHelper;
import org.eclipse.papyrus.customization.nattableconfiguration.messages.Messages;
import org.eclipse.papyrus.customization.nattableconfiguration.pages.ColumnConfigurationWizardPage;
import org.eclipse.papyrus.customization.nattableconfiguration.pages.EditGenericNattableConfigurationFieldsNattableWizardPage;
import org.eclipse.papyrus.customization.nattableconfiguration.pages.RowConfigurationWizardPage;
import org.eclipse.papyrus.customization.nattableconfiguration.pages.SlaveConfigurationWizardPage;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;
import org.eclipse.papyrus.infra.nattable.wizard.AbstractTableWizard;
import org.eclipse.papyrus.infra.ui.util.WorkbenchPartHelper;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class EditTableConfigurationWizard
extends AbstractTableWizard
implements IWorkbenchWizard {
    private static final String GENERATE_PlUGIN_ACTIVATOR = "generatePluginActivator";
    private static final String UI_PLUGIN = "uiPlugin";
    protected TableConfiguration configuration;
    protected Resource initialResource;
    protected TableConfigurationHelper helper;

    public EditTableConfigurationWizard() {
        ImageDescriptor desc = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImageDescriptor("org.eclipse.papyrus.customization.nattableconfiguration", "icons/papyrusNattableconfigurationWizban.png");
        this.setDefaultPageImageDescriptor(desc);
        this.setWindowTitle(Messages.CreateNattableConfigurationWizard_WizardTitke);
        this.setForcePreviousAndNextButtons(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.initialResource = this.getSelectedResource((ISelection)selection);
        this.configuration = this.getEditedTableConfiguration(this.initialResource);
        Assert.isNotNull((Object)this.configuration);
        this.helper = new TableConfigurationHelper(this.configuration);
    }

    protected Resource getSelectedResource(ISelection currentSelection) {
        Object selectedElement;
        Resource resource = null;
        if (currentSelection instanceof StructuredSelection && 1 == ((StructuredSelection)currentSelection).size() && (selectedElement = ((StructuredSelection)currentSelection).getFirstElement()) instanceof File && "nattableconfiguration".equals(((File)selectedElement).getFileExtension())) {
            INattableModelManager manager = null;
            IEditorPart currentPart = WorkbenchPartHelper.getCurrentActiveWorkbenchPart().getSite().getPage().getActiveEditor();
            if (currentPart != null) {
                manager = (INattableModelManager)currentPart.getAdapter(INattableModelManager.class);
            }
            if (manager != null) {
                resource = TableEditingDomainUtils.getTableEditingDomain((Table)manager.getTable()).getResourceSet().getResource(URI.createFileURI((String)((File)selectedElement).getLocation().toString()), true);
            } else {
                ResourceSetImpl set = new ResourceSetImpl();
                resource = set.getResource(URI.createFileURI((String)((File)selectedElement).getLocation().toString()), true);
            }
        }
        return resource;
    }

    protected TableConfiguration getEditedTableConfiguration(Resource resource) {
        TableConfiguration configuration = null;
        if (resource != null && !resource.getContents().isEmpty() && resource.getContents().get(0) instanceof TableConfiguration) {
            configuration = (TableConfiguration)EcoreUtil.copy((EObject)((TableConfiguration)resource.getContents().get(0)));
        }
        return configuration;
    }

    public void addPages() {
        this.addEditNattableConfigurationPage();
        this.addPage((IWizardPage)new RowConfigurationWizardPage(this.helper));
        this.addPage((IWizardPage)new ColumnConfigurationWizardPage(this.helper));
        this.addPage((IWizardPage)new SlaveConfigurationWizardPage(this.helper));
    }

    protected void addEditNattableConfigurationPage() {
        this.addPage((IWizardPage)new EditGenericNattableConfigurationFieldsNattableWizardPage(this.helper));
    }

    public IDialogSettings getDialogSettings() {
        DialogSettings dialogSettings = new DialogSettings("");
        dialogSettings.put(GENERATE_PlUGIN_ACTIVATOR, true);
        dialogSettings.put(UI_PLUGIN, false);
        return dialogSettings;
    }

    public boolean performFinish() {
        boolean result = false;
        if (this.initialResource != null) {
            this.initialResource.getContents().clear();
            this.initialResource.getContents().add((Object)this.configuration);
            result = true;
        }
        if (result) {
            result = this.saveResource();
        }
        return result;
    }

    protected final boolean saveResource() {
        boolean result = true;
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        saveOptions.put("LINE_DELIMITER", "");
        try {
            this.initialResource.save(saveOptions);
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
            result = false;
        }
        return result;
    }
}

