/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.releng.tools.internal.popup.actions;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.cbi.p2repo.aggregator.Contribution;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.releng.tools.internal.popup.actions.XMLDependencyUpdater;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OomphSetupUpdater
extends XMLDependencyUpdater {
    public static final String ANNOTATION_SOURCE = "http://www.eclipse.org/Papyrus/2014/releng/dependencytools";
    public static final String UPDATE_KEY = "updateFrom";
    private final Pattern annotationPattern = Pattern.compile("updateFrom:([^:]+):(\\d+)");
    private final Pattern indexPattern = Pattern.compile(":\\d+$");
    private String streamName;

    @Override
    public boolean canUpdate(IFile file) {
        return "setup".equals(file.getFileExtension());
    }

    @Override
    public void updateDocument(Shell parentShell, IFile mapFile, EList<Contribution> contributions, Map<Object, Object> context) throws CoreException {
        this.streamName = this.promptForStreamName(parentShell, mapFile, context);
        if (this.streamName == null) {
            return;
        }
        super.updateDocument(parentShell, mapFile, contributions, context);
    }

    @Override
    protected Pattern getCommentPattern() {
        return this.annotationPattern;
    }

    @Override
    protected String getCommentContent(Node comment) {
        StringBuilder result = new StringBuilder("updateFrom:");
        Element annotation = (Element)comment;
        NodeList details = annotation.getElementsByTagName("detail");
        int i = 0;
        while (i < details.getLength()) {
            Element next = (Element)details.item(i);
            if (UPDATE_KEY.equals(next.getAttribute("key"))) {
                String repoSpec = null;
                if (next.hasAttribute("value")) {
                    repoSpec = next.getAttribute("value");
                } else {
                    NodeList values = next.getElementsByTagName("value");
                    if (values.getLength() > 0) {
                        repoSpec = values.item(0).getTextContent().trim();
                    }
                }
                if (repoSpec != null) {
                    result.append(repoSpec);
                    if (!this.indexPattern.matcher(repoSpec).find()) {
                        result.append(":0");
                        break;
                    }
                }
            }
            ++i;
        }
        return result.toString();
    }

    @Override
    protected String getCommentSyntax() {
        return String.format("Annotation with source %s and detail 'updateFrom=<contributionName>[:<index>]?'", ANNOTATION_SOURCE);
    }

    @Override
    protected Node getPrecedingComment(Node node) {
        Element result = null;
        Node next = node.getFirstChild();
        while (next != null) {
            Element annotation;
            if (next.getNodeType() == 1 && "annotation".equals(next.getNodeName()) && ANNOTATION_SOURCE.equals((annotation = (Element)next).getAttribute("source"))) {
                result = annotation;
                break;
            }
            next = next.getNextSibling();
        }
        return result;
    }

    @Override
    protected String getXpath() {
        return String.format("//setupTask[@type='setup.targlets:TargletTask']/targlet/repositoryList[@name='%s']/repository", this.streamName);
    }

    @Override
    protected String getCurrentLocation(Node uri) {
        return uri.getAttributes().getNamedItem("url").getTextContent();
    }

    @Override
    protected void updateUri(Node uri, String location) {
        uri.getAttributes().getNamedItem("url").setTextContent(location);
    }

    @Override
    protected void save(Document document, File destination) throws Exception {
        ResourceSetImpl rset = new ResourceSetImpl();
        Resource resource = rset.createResource(URI.createFileURI((String)destination.getAbsolutePath()));
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("RECORD_UNKNOWN_FEATURE", true);
        options.put("DEFER_IDREF_RESOLUTION", true);
        ((XMLResource)resource).load((Node)document, options);
        options.clear();
        options.put("FORMATTED", true);
        options.put("PROCESS_DANGLING_HREF", "RECORD");
        resource.save(options);
    }

    protected String promptForStreamName(Shell parentShell, IFile setupFile, Map<Object, Object> context) throws CoreException {
        String key = "$setup.stream$";
        String result = (String)context.get("$setup.stream$");
        if (result != null) {
            return result;
        }
        final LinkedHashSet repositoryLists = new LinkedHashSet();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (InputStream input = setupFile.getContents();){
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                parser.parse(input, new DefaultHandler(){
                    int inTarglet;
                    String repositoryListName;
                    boolean foundAnnotation;

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if ("targlet".equals(qName)) {
                            if (this.inTarglet > 0 || "${eclipse.target.platform}".equals(attributes.getValue("activeRepositoryList"))) {
                                ++this.inTarglet;
                            }
                        } else if (this.inTarglet > 0 && "repositoryList".equals(qName)) {
                            String listName = attributes.getValue("name");
                            if (listName != null && !listName.isEmpty()) {
                                this.repositoryListName = listName;
                                this.foundAnnotation = false;
                            }
                        } else if ("annotation".equals(qName) && OomphSetupUpdater.ANNOTATION_SOURCE.equals(attributes.getValue("source"))) {
                            this.foundAnnotation = true;
                        }
                    }

                    @Override
                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        if ("targlet".equals(qName)) {
                            this.inTarglet = Math.max(this.inTarglet - 1, 0);
                        } else if ("repositoryList".equals(qName) && this.repositoryListName != null) {
                            if (this.foundAnnotation) {
                                repositoryLists.add(this.repositoryListName);
                            }
                            this.repositoryListName = null;
                            this.foundAnnotation = false;
                        }
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.releng.tools", "Failed to scan setup model for available streams.", (Throwable)e));
        }
        if (repositoryLists.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.releng.tools", "No streams are defined in the selected setup model."));
        }
        String first = (String)repositoryLists.iterator().next();
        if (repositoryLists.size() == 1) {
            return first;
        }
        LabelProvider labels = new LabelProvider();
        ListDialog dlg = new ListDialog(parentShell);
        dlg.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
        dlg.setLabelProvider((ILabelProvider)labels);
        dlg.setInput(repositoryLists);
        dlg.setInitialSelections(new Object[]{repositoryLists.iterator().next()});
        dlg.setTitle("Select Stream");
        dlg.setMessage(NLS.bind((String)"Select the development stream to update in \"{0}\".", (Object)setupFile.getFullPath()));
        labels.dispose();
        dlg.open();
        Object[] dlgResult = dlg.getResult();
        String string = result = dlgResult == null || dlgResult.length == 0 ? null : (String)dlgResult[0];
        if (result != null) {
            context.put("$setup.stream$", result);
        }
        return result;
    }
}

