/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.profile.internal.quickfix;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.CommonMarkerResolutionUtils;
import org.eclipse.papyrus.toolsmiths.validation.profile.internal.quickfix.StaticProfileHelper;
import org.eclipse.papyrus.uml.tools.utils.StaticProfileUtil;
import org.eclipse.uml2.uml.Profile;

public final class ProfileMarkerResolutionUtils {
    public static IFile getGenModelFile(IMarker marker) throws CoreException {
        IFile umlModelFile = ProfileMarkerResolutionUtils.getUMLModelFile(marker);
        if (umlModelFile == null) {
            return null;
        }
        IPath genModelFilePath = umlModelFile.getFullPath().removeFileExtension().addFileExtension("genmodel");
        return ResourcesPlugin.getWorkspace().getRoot().getFile(genModelFilePath);
    }

    public static IFile getUMLModelFile(IMarker marker) throws CoreException {
        Optional<Profile> profileOptional = ProfileMarkerResolutionUtils.getProfile(marker);
        if (profileOptional.isEmpty()) {
            return null;
        }
        Profile profile = profileOptional.get();
        Resource umlModelResource = profile.eResource();
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(umlModelResource.getURI().toPlatformString(true)));
    }

    public static String getStereotypeUri(IMarker marker) {
        Optional<Profile> profile = ProfileMarkerResolutionUtils.getProfile(marker);
        if (profile.isEmpty()) {
            return null;
        }
        return ProfileMarkerResolutionUtils.getStereotypeUri(profile.get());
    }

    public static String getStereotypeUri(Profile profile) {
        return new StaticProfileUtil(profile).getDefinition().getNsURI();
    }

    public static Optional<Profile> getProfile(IMarker marker) {
        return CommonMarkerResolutionUtils.getModelName((IMarker)marker).flatMap(profileName -> {
            Map<IFile, List<Profile>> profiles = StaticProfileHelper.findStaticProfiles(marker.getResource().getProject(), true);
            return profiles.values().stream().flatMap(Collection::stream).filter(profile -> Objects.equals(profile.getName(), profileName)).findFirst();
        });
    }
}

