/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.types.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.edit.context.TypeContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ElementTypeInfo
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(currentSelection instanceof IStructuredSelection) || currentSelection.isEmpty()) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)currentSelection;
        for (Object selectedElement : selection) {
            EObject adapted;
            if (!(selectedElement instanceof IAdaptable) || (adapted = (EObject)((IAdaptable)selectedElement).getAdapter(EObject.class)) == null) continue;
            try {
                IElementType[] types = ElementTypeRegistry.getInstance().getAllTypesMatching(adapted, TypeContext.getContext((EObject)adapted));
                String result = "";
                IElementType[] iElementTypeArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IElementType iElementType = iElementTypeArray[n2];
                    result = String.valueOf(result) + iElementType.getId() + "\n";
                    ++n2;
                }
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Matching ElementTypes", (String)result);
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

