/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.assistants.generator;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.papyrus.infra.gmfdiag.assistant.AssistantFactory;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ModelingAssistantProvider;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.uml.profile.assistants.generator.ConnectionAssistantRule;
import org.eclipse.papyrus.uml.profile.assistants.generator.FiltersUtil;
import org.eclipse.papyrus.uml.profile.assistants.generator.PopupAssistantRule;
import org.eclipse.papyrus.uml.profile.types.generator.Identifiers;
import org.eclipse.papyrus.uml.profile.types.generator.ImpliedExtension;
import org.eclipse.papyrus.uml.profile.types.generator.UML;
import org.eclipse.papyrus.uml.profile.types.generator.UMLElementTypes;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class ModelingAssistantProviderRule {
    @Extension
    private static AssistantFactory assistantFactory = AssistantFactory.eINSTANCE;
    @Inject
    @Extension
    private Identifiers _identifiers;
    @Inject
    @Extension
    private UML _uML;
    @Inject
    @Extension
    private UMLElementTypes _uMLElementTypes;
    @Inject
    @Extension
    private FiltersUtil _filtersUtil;
    @Inject
    @Extension
    private PopupAssistantRule _popupAssistantRule;
    @Inject
    @Extension
    private ConnectionAssistantRule _connectionAssistantRule;
    private final HashMap<ArrayList<?>, ModelingAssistantProvider> _createCache_toModelingAssistantProvider = CollectionLiterals.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelingAssistantProvider toModelingAssistantProvider(Profile umlProfile) {
        ModelingAssistantProvider _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Profile[]{umlProfile});
        HashMap<ArrayList<?>, ModelingAssistantProvider> hashMap = this._createCache_toModelingAssistantProvider;
        synchronized (hashMap) {
            ModelingAssistantProvider _createModelingAssistantProvider;
            if (this._createCache_toModelingAssistantProvider.containsKey(_cacheKey)) {
                return this._createCache_toModelingAssistantProvider.get(_cacheKey);
            }
            _result = _createModelingAssistantProvider = assistantFactory.createModelingAssistantProvider();
            this._createCache_toModelingAssistantProvider.put(_cacheKey, _result);
        }
        this._init_toModelingAssistantProvider(_result, umlProfile);
        return _result;
    }

    private void _init_toModelingAssistantProvider(ModelingAssistantProvider it, Profile umlProfile) {
        this._identifiers.setIdentifierBase((Package)umlProfile);
        it.setName(umlProfile.getName());
        Consumer<ImpliedExtension> _function = ext -> {
            boolean _not;
            Functions.Function1 _function_1 = it_1 -> this._identifiers.toElementTypeID(ext, it_1);
            Iterable profileElementTypes = IterableExtensions.map((Iterable)this._uMLElementTypes.getDiagramSpecificElementTypes(ext.getMetaclass()), (Functions.Function1)_function_1);
            Consumer<String> _function_2 = it_1 -> this._filtersUtil.toElementTypeFilter((String)it_1, umlProfile);
            profileElementTypes.forEach(_function_2);
            boolean _isRelationship = this._uML.isRelationship(this._uMLElementTypes.getEClass(ext.getMetaclass()));
            boolean bl = _not = !_isRelationship;
            if (_not) {
                Iterables.addAll((Collection)it.getElementTypeIDs(), (Iterable)profileElementTypes);
                Functions.Function1 _function_3 = it_1 -> this._popupAssistantRule.toPopupAssistant((ImpliedExtension)ext, (ElementTypeConfiguration)it_1);
                Iterables.addAll((Collection)it.getPopupAssistants(), (Iterable)IterableExtensions.map((Iterable)this._uMLElementTypes.getDiagramSpecificElementTypes(ext.getMetaclass()), (Functions.Function1)_function_3));
            } else {
                Iterables.addAll((Collection)it.getRelationshipTypeIDs(), (Iterable)profileElementTypes);
                Functions.Function1 _function_4 = it_1 -> this._connectionAssistantRule.toConnectionAssistant((ImpliedExtension)ext, (ElementTypeConfiguration)it_1);
                Iterables.addAll((Collection)it.getConnectionAssistants(), (Iterable)IterableExtensions.map((Iterable)this._uMLElementTypes.getDiagramSpecificElementTypes(ext.getMetaclass()), (Functions.Function1)_function_4));
            }
        };
        this._uML.getAllExtensions((Package)umlProfile).forEach(_function);
    }
}

