/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.project.management.internal.operations;

import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.papyrus.dev.project.management.internal.operations.AbstractManifestUpdateOperation;
import org.eclipse.papyrus.dev.project.management.internal.operations.DependencyKind;
import org.eclipse.papyrus.dev.project.management.internal.operations.VersionRules;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IManifestEditor;
import org.osgi.framework.VersionRange;

public class UpdateDependencyRangesOperation
extends AbstractManifestUpdateOperation {
    private final VersionRules versionRules = new VersionRules();

    public UpdateDependencyRangesOperation(Map<? extends IFile, ? extends IManifestEditor> manifests) {
        super("Update Dependency Ranges", manifests);
    }

    @Override
    protected IStatus doExecute(IProgressMonitor monitor, Map<? extends IFile, ? extends IManifestEditor> manifests) throws ExecutionException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Updating manifests...", (int)(manifests.size() * 2));
        for (IManifestEditor iManifestEditor : manifests.values()) {
            if (sub.isCanceled()) {
                throw new OperationCanceledException();
            }
            iManifestEditor.init();
            this.updateDependencies(iManifestEditor, DependencyKind.REQUIRE_BUNDLE);
            sub.worked(1);
            if (sub.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.updateDependencies(iManifestEditor, DependencyKind.IMPORT_PACKAGE);
            sub.worked(1);
        }
        sub.done();
        return Status.OK_STATUS;
    }

    private void updateDependencies(IManifestEditor manifest, DependencyKind kind) {
        for (Object dependency : kind.getDependencies(manifest)) {
            String dependencyName = kind.getDependencyName(dependency);
            VersionRange range = this.versionRules.getDependencyVersionRange(kind, dependencyName);
            if (range == null) continue;
            kind.setDependencyRange(manifest, dependencyName, range);
        }
    }
}

