/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.diagram.editpolicies;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common;
import xpt.providers.ElementTypes;

@Singleton
@SuppressWarnings("all")
public class GraphicalNodeEditPolicy {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  private ElementTypes xptElementTypes;
  
  public CharSequence className(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    String _graphicalNodeEditPolicyClassName = it.getGraphicalNodeEditPolicyClassName();
    _builder.append(_graphicalNodeEditPolicyClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPoliciesPackageName = it.getDiagram().getEditPoliciesPackageName();
    _builder.append(_editPoliciesPackageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence GraphicalNodeEditPolicy(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" ");
    CharSequence _implementsList = this.implementsList(it);
    _builder.append(_implementsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _connectionCompleteCommand = this.getConnectionCompleteCommand(it);
    _builder.append(_connectionCompleteCommand, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _elementType = this.getElementType(it);
    _builder.append(_elementType, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _connectionWithReorientedViewCompleteCommand = this.getConnectionWithReorientedViewCompleteCommand(it);
    _builder.append(_connectionWithReorientedViewCompleteCommand, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence extendsList(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy");
    return _builder;
  }
  
  public CharSequence implementsList(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence getConnectionCompleteCommand(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command getConnectionCompleteCommand(");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gef.requests.CreateConnectionRequest request) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.IElementType elementType = getElementType(request);");
    _builder.newLine();
    {
      final Function1<GenLink, Integer> _function = new Function1<GenLink, Integer>() {
        @Override
        public Integer apply(final GenLink l) {
          return Integer.valueOf(l.getVisualID());
        }
      };
      List<GenLink> _sortBy = IterableExtensions.<GenLink, Integer>sortBy(it.getReorientedIncomingLinks(), _function);
      for(final GenLink link : _sortBy) {
        _builder.append("\t");
        _builder.append("if (");
        CharSequence _accessElementType = this.xptElementTypes.accessElementType(link);
        _builder.append(_accessElementType, "\t");
        _builder.append(" == elementType) {");
        _builder.newLineIfNotEmpty();
        {
          boolean _isOutgoingCreationAllowed = link.isOutgoingCreationAllowed();
          if (_isOutgoingCreationAllowed) {
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if (request.getSourceEditPart() != getHost()) {");
            _builder.newLine();
          }
        }
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return getConnectionWithReorientedViewCompleteCommand(request);");
        _builder.newLine();
        {
          boolean _isOutgoingCreationAllowed_1 = link.isOutgoingCreationAllowed();
          if (_isOutgoingCreationAllowed_1) {
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
          }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return super.getConnectionCompleteCommand(request);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getElementType(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gmf.runtime.emf.type.core.IElementType getElementType(");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gef.requests.CreateConnectionRequest request) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (request instanceof org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter requestAdapter =");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("((org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest) request)");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append(".getConnectionViewAndElementDescriptor().getCreateElementRequestAdapter();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return (org.eclipse.gmf.runtime.emf.type.core.IElementType) requestAdapter.getAdapter(");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.IElementType.class);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getConnectionWithReorientedViewCompleteCommand(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command getConnectionWithReorientedViewCompleteCommand(");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gef.requests.CreateConnectionRequest request) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy c =");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("(org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy) super.getConnectionCompleteCommand(request);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.common.core.command.CompositeCommand cc =");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("(org.eclipse.gmf.runtime.common.core.command.CompositeCommand) c.getICommand();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.transaction.TransactionalEditingDomain editingDomain =");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("((org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart) getHost()).getEditingDomain();");
    _builder.newLine();
    _builder.append("\t");
    String _reorientConnectionViewCommandQualifiedClassName = it.getDiagram().getReorientConnectionViewCommandQualifiedClassName();
    _builder.append(_reorientConnectionViewCommandQualifiedClassName, "\t");
    _builder.append(" rcvCommand =");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("new ");
    String _reorientConnectionViewCommandQualifiedClassName_1 = it.getDiagram().getReorientConnectionViewCommandQualifiedClassName();
    _builder.append(_reorientConnectionViewCommandQualifiedClassName_1, "\t");
    _builder.append("(editingDomain, null);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("rcvCommand.setEdgeAdaptor(getViewAdapter());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("cc.compose(rcvCommand);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return c;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence additions(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
