/**
 * Copyright (c) 2006, 2009, 2013, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.2 cleanup + less code with AbstractExternalLabelEditPart
 */
package diagram.editparts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import impl.diagram.editparts.TextAwareExtent;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExternalNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenFloatingLabel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.CodeStyle;
import xpt.Common;
import xpt.editor.VisualIDRegistry;

@Singleton
@SuppressWarnings("all")
public class ExternalNodeLabelEditPart {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private CodeStyle _codeStyle;
  
  @Inject
  private VisualIDRegistry xptVisualIDRegistry;
  
  @Inject
  private xpt.diagram.editparts.Common xptEditpartsCommon;
  
  @Inject
  private TextAwareExtent xptTextAware;
  
  public CharSequence qualifiedClassName(final GenExternalNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenExternalNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence Main(final GenExternalNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    String _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" ");
    CharSequence _implementsList = this.implementsList(it);
    _builder.append(_implementsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _attributes = this.attributes(it);
    _builder.append(_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _initializer = this.initializer(it);
    _builder.append(_initializer, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _constructor = this.constructor(it);
    _builder.append(_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createDefaultEditPolicies = this.createDefaultEditPolicies(it);
    _builder.append(_createDefaultEditPolicies, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _labelIconNotUseElementIcon = this.xptTextAware.getLabelIconNotUseElementIcon(it, it.isElementIcon(), it.getDiagram());
    _builder.append(_labelIconNotUseElementIcon, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _methodsExtent = this.xptTextAware.methodsExtent(it, false, it.isReadOnly(), it.getModelFacet(), it.getNode());
    _builder.append(_methodsExtent, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createFigure = this.createFigure(it);
    _builder.append(_createFigure, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence className(final GenExternalNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartClassName = it.getEditPartClassName();
    _builder.append(_editPartClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenExternalNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartsPackageName = it.getDiagram().getEditPartsPackageName();
    _builder.append(_editPartsPackageName);
    return _builder;
  }
  
  public String extendsList(final GenExternalNodeLabel it) {
    String _xifexpression = null;
    String _superEditPart = it.getSuperEditPart();
    boolean _tripleNotEquals = (_superEditPart != null);
    if (_tripleNotEquals) {
      String _superEditPart_1 = it.getSuperEditPart();
      _xifexpression = ("extends " + _superEditPart_1);
    } else {
      _xifexpression = "extends org.eclipse.papyrus.uml.diagram.common.editparts.AbstractExternalLabelEditPart";
    }
    return _xifexpression;
  }
  
  public CharSequence implementsList(final GenExternalNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("implements org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart, org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart");
    _builder.newLine();
    {
      GenFloatingLabel _labelVisibilityPreference = it.getLabelVisibilityPreference();
      boolean _tripleNotEquals = (_labelVisibilityPreference != null);
      if (_tripleNotEquals) {
        _builder.append(", org.eclipse.papyrus.uml.diagram.common.editparts.ILabelRoleProvider");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence attributes(final GenExternalNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _visualIDConstant = this.xptEditpartsCommon.visualIDConstant(it);
    _builder.append(_visualIDConstant);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence constructor(final GenExternalNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("super(view);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence initializer(final GenExternalNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("static {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("registerSnapBackPosition(");
    CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(it);
    _builder.append(_typeMethodCall, "\t");
    _builder.append(", new org.eclipse.draw2d.geometry.Point(0, 0));");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createDefaultEditPolicies(final GenExternalNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isEmpty = it.getBehaviour().isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append(_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void createDefaultEditPolicies() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("super.createDefaultEditPolicies();");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _behaviour = this.xptEditpartsCommon.behaviour(it);
        _builder.append(_behaviour, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence additions(final GenExternalNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenFloatingLabel _labelVisibilityPreference = it.getLabelVisibilityPreference();
      boolean _tripleNotEquals = (_labelVisibilityPreference != null);
      if (_tripleNotEquals) {
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append(_generatedClassComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideI = this._codeStyle.overrideI(it);
        _builder.append(_overrideI);
        _builder.newLineIfNotEmpty();
        _builder.append("public String getLabelRole(){");
        _builder.newLine();
        _builder.append("return \"");
        String _role = it.getLabelVisibilityPreference().getRole();
        _builder.append(_role);
        _builder.append("\";//$NON-NLS-1$");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedClassComment_1 = this._common.generatedClassComment();
        _builder.append(_generatedClassComment_1);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideI_1 = this._codeStyle.overrideI(it);
        _builder.append(_overrideI_1);
        _builder.newLineIfNotEmpty();
        _builder.append("public String getIconPathRole(){");
        _builder.newLine();
        _builder.append("return \"");
        String _iconPathRole = it.getLabelVisibilityPreference().getIconPathRole();
        _builder.append(_iconPathRole);
        _builder.append("\";//$NON-NLS-1$");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence createFigure(final GenExternalNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _labelFigure = this.xptEditpartsCommon.labelFigure(it.getViewmap());
    _builder.append(_labelFigure);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
