/**
 * Copyright (c) 2015 Christian W. Damus and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Christian W. Damus - Initial API and implementation
 */
package org.eclipse.papyrus.uml.profile.types.generator;

import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

/**
 * An analogue of the UML {@code Extension} metaclass that represents an implied metaclass extension.
 * This may be modeled in the profile either directly, via an extension, or indirectly, via an
 * inherited extension.
 */
@Data
@SuppressWarnings("all")
public class ImpliedExtension {
  private final Stereotype stereotype;
  
  private final org.eclipse.uml2.uml.Class metaclass;
  
  public ImpliedExtension(final Stereotype stereotype, final org.eclipse.uml2.uml.Class metaclass) {
    super();
    this.stereotype = stereotype;
    this.metaclass = metaclass;
  }
  
  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.stereotype== null) ? 0 : this.stereotype.hashCode());
    return prime * result + ((this.metaclass== null) ? 0 : this.metaclass.hashCode());
  }
  
  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    ImpliedExtension other = (ImpliedExtension) obj;
    if (this.stereotype == null) {
      if (other.stereotype != null)
        return false;
    } else if (!this.stereotype.equals(other.stereotype))
      return false;
    if (this.metaclass == null) {
      if (other.metaclass != null)
        return false;
    } else if (!this.metaclass.equals(other.metaclass))
      return false;
    return true;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("stereotype", this.stereotype);
    b.add("metaclass", this.metaclass);
    return b.toString();
  }
  
  @Pure
  public Stereotype getStereotype() {
    return this.stereotype;
  }
  
  @Pure
  public org.eclipse.uml2.uml.Class getMetaclass() {
    return this.metaclass;
  }
}
