/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * 	Artem Tikhomirov (Borland) - initial API and implementation
 * 	Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * 	Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditContext;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditRoot;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditRule;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagramElementTarget;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNotationElementTarget;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

/**
 * FIXME: [MG] Why it is here, in xpt?
 */
@Singleton
@SuppressWarnings("all")
public class GenAuditRoot_qvto {
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  public Iterable<GenPackage> getAllTargetedModelPackages(final GenAuditRoot root) {
    final Function1<GenAuditRule, Boolean> _function = new Function1<GenAuditRule, Boolean>() {
      @Override
      public Boolean apply(final GenAuditRule r) {
        return Boolean.valueOf(((r.getTarget() != null) && (r.getTarget().getTargetClass() != null)));
      }
    };
    final Function1<GenAuditRule, GenPackage> _function_1 = new Function1<GenAuditRule, GenPackage>() {
      @Override
      public GenPackage apply(final GenAuditRule r) {
        return r.getTarget().getTargetClass().getGenPackage();
      }
    };
    return IterableExtensions.<GenPackage>toSet(IterableExtensions.<GenAuditRule, GenPackage>map(IterableExtensions.<GenAuditRule>filter(root.getRules(), _function), _function_1));
  }
  
  public String getQualifiedIdentity(final GenAuditContext ctx) {
    String _iD = ctx.getRoot().getEditorGen().getPlugin().getID();
    String _id = ctx.getId();
    return (_iD + _id);
  }
  
  public boolean hasDiagramElementTargetRule(final GenAuditRoot audits) {
    return ((audits != null) && IterableExtensions.<GenAuditRule>exists(audits.getRules(), new Function1<GenAuditRule, Boolean>() {
      @Override
      public Boolean apply(final GenAuditRule r) {
        return Boolean.valueOf(GenAuditRoot_qvto.this._common_qvto.oclIsKindOf(r.getTarget(), GenDiagramElementTarget.class));
      }
    }));
  }
  
  public boolean hasAnyNotationElementTargetRule(final GenAuditRoot audits) {
    return ((audits != null) && IterableExtensions.<GenAuditRule>exists(audits.getRules(), new Function1<GenAuditRule, Boolean>() {
      @Override
      public Boolean apply(final GenAuditRule r) {
        return Boolean.valueOf(GenAuditRoot_qvto.this._common_qvto.oclIsKindOf(r.getTarget(), GenNotationElementTarget.class));
      }
    }));
  }
  
  public boolean shouldRunValidateOnDiagram(final GenAuditRoot audits) {
    return (this.hasDiagramElementTargetRule(audits) || this.hasAnyNotationElementTargetRule(audits));
  }
  
  public Iterable<GenCommonBase> getTargetDiagramElements(final GenAuditContext ctx) {
    final Function1<GenDiagramElementTarget, EList<GenCommonBase>> _function = new Function1<GenDiagramElementTarget, EList<GenCommonBase>>() {
      @Override
      public EList<GenCommonBase> apply(final GenDiagramElementTarget t) {
        return t.getElement();
      }
    };
    return IterableExtensions.<GenCommonBase>toSet(Iterables.<GenCommonBase>concat(IterableExtensions.<GenDiagramElementTarget, EList<GenCommonBase>>map(Iterables.<GenDiagramElementTarget>filter(ctx.getRuleTargets(), GenDiagramElementTarget.class), _function)));
  }
  
  public Iterable<GenCommonBase> getAllTargetDiagramElements(final GenAuditRoot root) {
    final Function1<GenAuditContext, Iterable<GenCommonBase>> _function = new Function1<GenAuditContext, Iterable<GenCommonBase>>() {
      @Override
      public Iterable<GenCommonBase> apply(final GenAuditContext c) {
        return GenAuditRoot_qvto.this.getTargetDiagramElements(c);
      }
    };
    return IterableExtensions.<GenCommonBase>toSet(Iterables.<GenCommonBase>concat(ListExtensions.<GenAuditContext, Iterable<GenCommonBase>>map(root.getClientContexts(), _function)));
  }
}
