/**
 * Copyright (c) 2014, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * 	Svyatoslav Kovalsky (Montages) - initial API and implementation
 * 	Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 * 	Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up
 */
package xpt;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditContainer;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditContext;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditRoot;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditRule;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenConstraint;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenSeverity;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
@SuppressWarnings("all")
public class ConstraintProviders {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private GenAuditRoot_qvto _genAuditRoot_qvto;
  
  @Inject
  @Extension
  private GenEditorGenerator_qvto _genEditorGenerator_qvto;
  
  public CharSequence extensions(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasAudits = this._genEditorGenerator_qvto.hasAudits(it);
      if (_hasAudits) {
        CharSequence _extensions = this.extensions(it.getAudits());
        _builder.append(_extensions);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence extensions(final GenAuditRoot it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _extensions_emfv_constraintProviders = this.extensions_emfv_constraintProviders(it);
    _builder.append(_extensions_emfv_constraintProviders);
    _builder.newLineIfNotEmpty();
    CharSequence _extensions_emfv_constraintBindings = this.extensions_emfv_constraintBindings(it);
    _builder.append(_extensions_emfv_constraintBindings);
    _builder.newLineIfNotEmpty();
    CharSequence _extensions_emfv_uiContexts = this.extensions_emfv_uiContexts(it);
    _builder.append(_extensions_emfv_uiContexts);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence extensions_emfv_constraintProviders(final GenAuditRoot it) {
    StringConcatenation _builder = new StringConcatenation();
    String _tripleSpace = this._common.tripleSpace(1);
    _builder.append(_tripleSpace);
    _builder.append("<extension point=\"org.eclipse.emf.validation.constraintProviders\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_1 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_1);
    CharSequence _xmlGeneratedTag = this._common.xmlGeneratedTag();
    _builder.append(_xmlGeneratedTag);
    _builder.newLineIfNotEmpty();
    {
      EList<GenAuditContainer> _categories = it.getCategories();
      for(final GenAuditContainer c : _categories) {
        CharSequence _declareCategory = this.declareCategory(c);
        _builder.append(_declareCategory);
      }
    }
    _builder.newLineIfNotEmpty();
    String _tripleSpace_2 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_2);
    _builder.append("<constraintProvider cache=\"true\">");
    _builder.newLineIfNotEmpty();
    {
      Iterable<GenPackage> _allTargetedModelPackages = this._genAuditRoot_qvto.getAllTargetedModelPackages(it);
      for(final GenPackage p : _allTargetedModelPackages) {
        _builder.append("\t");
        String _tripleSpace_3 = this._common.tripleSpace(3);
        _builder.append(_tripleSpace_3, "\t");
        _builder.append("<package namespaceUri=\"");
        String _nsURI = p.getEcorePackage().getNsURI();
        _builder.append(_nsURI, "\t");
        _builder.append("\"/>");
        _builder.newLineIfNotEmpty();
      }
    }
    String _tripleSpace_4 = this._common.tripleSpace(1);
    _builder.append(_tripleSpace_4);
    {
      EList<GenAuditContainer> _categories_1 = it.getCategories();
      for(final GenAuditContainer c_1 : _categories_1) {
        CharSequence _defineCategory = this.defineCategory(c_1);
        _builder.append(_defineCategory);
      }
    }
    _builder.newLineIfNotEmpty();
    String _tripleSpace_5 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_5);
    _builder.append("</constraintProvider>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_6 = this._common.tripleSpace(1);
    _builder.append(_tripleSpace_6);
    _builder.append("</extension>");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence extensions_emfv_constraintBindings(final GenAuditRoot it) {
    StringConcatenation _builder = new StringConcatenation();
    String _tripleSpace = this._common.tripleSpace(1);
    _builder.append(_tripleSpace);
    _builder.append("<extension point=\"org.eclipse.emf.validation.constraintBindings\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_1 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_1);
    CharSequence _xmlGeneratedTag = this._common.xmlGeneratedTag();
    _builder.append(_xmlGeneratedTag);
    _builder.newLineIfNotEmpty();
    {
      EList<GenAuditContext> _clientContexts = it.getClientContexts();
      for(final GenAuditContext ctx : _clientContexts) {
        String _tripleSpace_2 = this._common.tripleSpace(2);
        _builder.append(_tripleSpace_2);
        _builder.append("<clientContext default=\"false\" id=\"");
        String _qualifiedIdentity = this._genAuditRoot_qvto.getQualifiedIdentity(ctx);
        _builder.append(_qualifiedIdentity);
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_3 = this._common.tripleSpace(3);
        _builder.append(_tripleSpace_3);
        _builder.append("<selector class=\"");
        String _qualifiedClassName = ctx.getQualifiedClassName();
        _builder.append(_qualifiedClassName);
        _builder.append("\"/>");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_4 = this._common.tripleSpace(2);
        _builder.append(_tripleSpace_4);
        _builder.append("</clientContext>");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_5 = this._common.tripleSpace(2);
        _builder.append(_tripleSpace_5);
        _builder.append("<binding context=\"");
        String _qualifiedIdentity_1 = this._genAuditRoot_qvto.getQualifiedIdentity(ctx);
        _builder.append(_qualifiedIdentity_1);
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        {
          final Function1<GenAuditRule, Boolean> _function = new Function1<GenAuditRule, Boolean>() {
            @Override
            public Boolean apply(final GenAuditRule r) {
              return Boolean.valueOf(((r.getTarget() != null) && Objects.equal(r.getTarget().getContextSelector(), ctx)));
            }
          };
          Iterable<GenAuditRule> _filter = IterableExtensions.<GenAuditRule>filter(it.getRules(), _function);
          for(final GenAuditRule rule : _filter) {
            String _tripleSpace_6 = this._common.tripleSpace(6);
            _builder.append(_tripleSpace_6);
            _builder.append("<constraint ref=\"");
            String _iD = it.getEditorGen().getPlugin().getID();
            _builder.append(_iD);
            _builder.append(".");
            String _escapeXML = this._common.escapeXML(rule.getId());
            _builder.append(_escapeXML);
            _builder.append("\"/>");
            _builder.newLineIfNotEmpty();
          }
        }
        String _tripleSpace_7 = this._common.tripleSpace(5);
        _builder.append(_tripleSpace_7);
        _builder.append("</binding>");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
      }
    }
    String _tripleSpace_8 = this._common.tripleSpace(1);
    _builder.append(_tripleSpace_8);
    _builder.append("</extension>");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence extensions_emfv_uiContexts(final GenAuditRoot it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isLiveValidationUIFeedback = it.getEditorGen().getDiagram().isLiveValidationUIFeedback();
      if (_isLiveValidationUIFeedback) {
        String _tripleSpace = this._common.tripleSpace(1);
        _builder.append(_tripleSpace);
        _builder.append("<extension point=\"org.eclipse.emf.validation.ui.UIRegisteredClientContext\">");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_1 = this._common.tripleSpace(2);
        _builder.append(_tripleSpace_1);
        CharSequence _xmlGeneratedTag = this._common.xmlGeneratedTag();
        _builder.append(_xmlGeneratedTag);
        _builder.newLineIfNotEmpty();
        {
          EList<GenAuditContext> _clientContexts = it.getClientContexts();
          for(final GenAuditContext ctx : _clientContexts) {
            String _tripleSpace_2 = this._common.tripleSpace(3);
            _builder.append(_tripleSpace_2);
            _builder.append("<clientContext id=\"");
            String _qualifiedIdentity = this._genAuditRoot_qvto.getQualifiedIdentity(ctx);
            _builder.append(_qualifiedIdentity);
            _builder.append("\"/>");
            _builder.newLineIfNotEmpty();
          }
        }
        String _tripleSpace_3 = this._common.tripleSpace(2);
        _builder.append(_tripleSpace_3);
        _builder.append("</extension>");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence declareCategory(final GenAuditContainer it) {
    StringConcatenation _builder = new StringConcatenation();
    String _tripleSpace = this._common.tripleSpace(4);
    _builder.append(_tripleSpace);
    _builder.append("<category id=\"");
    CharSequence _pathMap = this.pathMap(it);
    _builder.append(_pathMap);
    _builder.append("\" mandatory=\"false\" name=\"");
    {
      String _name = it.getName();
      boolean _tripleNotEquals = (_name != null);
      if (_tripleNotEquals) {
        String _escapeXML = this._common.escapeXML(it.getName());
        _builder.append(_escapeXML);
      } else {
        CharSequence _pathMap_1 = this.pathMap(it);
        _builder.append(_pathMap_1);
      }
    }
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_1 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_1);
    _builder.append("<![CDATA[");
    {
      String _description = it.getDescription();
      boolean _tripleNotEquals_1 = (_description != null);
      if (_tripleNotEquals_1) {
        String _description_1 = it.getDescription();
        _builder.append(_description_1);
      } else {
      }
    }
    _builder.append("]]>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_2 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_2);
    _builder.append("</category>");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence defineCategory(final GenAuditContainer it) {
    StringConcatenation _builder = new StringConcatenation();
    String _tripleSpace = this._common.tripleSpace(4);
    _builder.append(_tripleSpace);
    _builder.append("<constraints categories=\"");
    CharSequence _pathMap = this.pathMap(it);
    _builder.append(_pathMap);
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    {
      final Function1<GenAuditRule, Boolean> _function = new Function1<GenAuditRule, Boolean>() {
        @Override
        public Boolean apply(final GenAuditRule a) {
          return Boolean.valueOf(((a.getTarget() != null) && (a.getTarget().getTargetClass() != null)));
        }
      };
      Iterable<GenAuditRule> _filter = IterableExtensions.<GenAuditRule>filter(it.getAudits(), _function);
      for(final GenAuditRule audit : _filter) {
        String _tripleSpace_1 = this._common.tripleSpace(6);
        _builder.append(_tripleSpace_1);
        _builder.append("<constraint id=\"");
        String _escapeXML = this._common.escapeXML(audit.getId());
        _builder.append(_escapeXML);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_2 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_2);
        {
          boolean _isRequiresConstraintAdapter = audit.isRequiresConstraintAdapter();
          if (_isRequiresConstraintAdapter) {
            _builder.append("lang=\"Java\" class=\"");
            String _constraintAdapterQualifiedClassName = audit.getConstraintAdapterQualifiedClassName();
            _builder.append(_constraintAdapterQualifiedClassName);
            _builder.append("\"");
          } else {
            _builder.append("lang=\"OCL\"");
          }
        }
        _builder.newLineIfNotEmpty();
        {
          String _name = audit.getName();
          boolean _tripleNotEquals = (_name != null);
          if (_tripleNotEquals) {
            _builder.append("\t");
            String _tripleSpace_3 = this._common.tripleSpace(4);
            _builder.append(_tripleSpace_3, "\t");
            _builder.append("name=\"");
            String _escapeXML_1 = this._common.escapeXML(audit.getName());
            _builder.append(_escapeXML_1, "\t");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
          } else {
            _builder.append("\t");
            String _tripleSpace_4 = this._common.tripleSpace(4);
            _builder.append(_tripleSpace_4, "\t");
            _builder.append("name=\"");
            String _escapeXML_2 = this._common.escapeXML(audit.getId());
            _builder.append(_escapeXML_2, "\t");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
          }
        }
        String _tripleSpace_5 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_5);
        _builder.append("mode=\"");
        {
          boolean _isUseInLiveMode = audit.isUseInLiveMode();
          if (_isUseInLiveMode) {
            _builder.append("Live");
          } else {
            _builder.append("Batch");
          }
        }
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_6 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_6);
        _builder.append("severity=\"");
        GenSeverity _severity = audit.getSeverity();
        _builder.append(_severity);
        _builder.append("\" statusCode=\"200\">");
        _builder.newLineIfNotEmpty();
        {
          String _description = audit.getDescription();
          boolean _tripleNotEquals_1 = (_description != null);
          if (_tripleNotEquals_1) {
            _builder.append("\t");
            String _tripleSpace_7 = this._common.tripleSpace(4);
            _builder.append(_tripleSpace_7, "\t");
            {
              boolean _isRequiresConstraintAdapter_1 = audit.isRequiresConstraintAdapter();
              boolean _not = (!_isRequiresConstraintAdapter_1);
              if (_not) {
                _builder.append("<![CDATA[");
                {
                  GenConstraint _rule = audit.getRule();
                  boolean _tripleNotEquals_2 = (_rule != null);
                  if (_tripleNotEquals_2) {
                    String _body = audit.getRule().getBody();
                    _builder.append(_body, "\t");
                  } else {
                  }
                }
                _builder.append("]]>");
              }
            }
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _tripleSpace_8 = this._common.tripleSpace(4);
            _builder.append(_tripleSpace_8, "\t");
            _builder.append("<description><![CDATA[");
            String _description_1 = audit.getDescription();
            _builder.append(_description_1, "\t");
            _builder.append("]]></description>");
            _builder.newLineIfNotEmpty();
          } else {
            _builder.append("\t");
            String _tripleSpace_9 = this._common.tripleSpace(4);
            _builder.append(_tripleSpace_9, "\t");
            _builder.append("<description><![CDATA[");
            _builder.append("]]></description>");
            _builder.newLineIfNotEmpty();
          }
        }
        {
          String _message = audit.getMessage();
          boolean _tripleNotEquals_3 = (_message != null);
          if (_tripleNotEquals_3) {
            _builder.append("\t");
            String _tripleSpace_10 = this._common.tripleSpace(4);
            _builder.append(_tripleSpace_10, "\t");
            _builder.append("<message><![CDATA[");
            String _message_1 = audit.getMessage();
            _builder.append(_message_1, "\t");
            _builder.append("]]></message>");
            _builder.newLineIfNotEmpty();
          } else {
            {
              String _name_1 = audit.getName();
              boolean _tripleNotEquals_4 = (_name_1 != null);
              if (_tripleNotEquals_4) {
                _builder.append("\t");
                String _tripleSpace_11 = this._common.tripleSpace(4);
                _builder.append(_tripleSpace_11, "\t");
                _builder.append("<message><![CDATA[");
                String _name_2 = audit.getName();
                _builder.append(_name_2, "\t");
                _builder.append(" audit violated]]></message>");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("\t");
                String _tripleSpace_12 = this._common.tripleSpace(4);
                _builder.append(_tripleSpace_12, "\t");
                _builder.append("<message><![CDATA[");
                String _id = audit.getId();
                _builder.append(_id, "\t");
                _builder.append(" audit violated]]></message>");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        String _tripleSpace_13 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_13);
        _builder.append("<target class=\"");
        String _targetClassModelQualifiedName = audit.getTarget().getTargetClassModelQualifiedName();
        _builder.append(_targetClassModelQualifiedName);
        _builder.append("\"/>");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_14 = this._common.tripleSpace(3);
        _builder.append(_tripleSpace_14);
        _builder.append("</constraint>");
        _builder.newLineIfNotEmpty();
      }
    }
    String _tripleSpace_15 = this._common.tripleSpace(6);
    _builder.append(_tripleSpace_15);
    _builder.append("</constraints>");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence pathMap(final GenAuditContainer it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<GenAuditContainer> _path = it.getPath();
      boolean _hasElements = false;
      for(final GenAuditContainer p : _path) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate("/", "");
        }
        String _escapeXML = this._common.escapeXML(p.getId());
        _builder.append(_escapeXML);
      }
    }
    return _builder;
  }
}
