/**
 * Copyright (c) 2006, 2009, 2013, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - L1.2 generate less dead or duplicate code
 */
package diagram.editparts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import impl.diagram.editparts.TextAwareExtent;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ParentAssignedViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.CodeStyle;
import xpt.Common;
import xpt.diagram.editparts.Utils_qvto;

@Singleton
@SuppressWarnings("all")
public class NodeLabelEditPart {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private CodeStyle _codeStyle;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  private TextAwareExtent xptTextAware;
  
  @Inject
  private xpt.diagram.editparts.Common xptEditpartsCommon;
  
  public CharSequence Main(final GenNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _attributes = this.attributes(it);
    _builder.append(_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _constructor = this.constructor(it);
    _builder.append(_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _createDefaultEditPolicies = this.createDefaultEditPolicies(it);
    _builder.append(_createDefaultEditPolicies, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _labelIconNotUseElementIcon = this.xptTextAware.getLabelIconNotUseElementIcon(it, it.isElementIcon(), it.getDiagram());
    _builder.append(_labelIconNotUseElementIcon, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _methodsExtent = this.xptTextAware.methodsExtent(it, this._utils_qvto.isStoringChildPositions(it.getNode()), it.isReadOnly(), it.getModelFacet(), it.getNode());
    _builder.append(_methodsExtent, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _handleNotificationEventExtent = this.handleNotificationEventExtent(it);
    _builder.append(_handleNotificationEventExtent, "\t");
    _builder.newLineIfNotEmpty();
    {
      Viewmap _viewmap = it.getViewmap();
      boolean _not = (!(_viewmap instanceof ParentAssignedViewmap));
      if (_not) {
        _builder.append("\t");
        CharSequence _labelFigure = this.xptEditpartsCommon.labelFigure(it.getViewmap());
        _builder.append(_labelFigure, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence className(final GenNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartClassName = it.getEditPartClassName();
    _builder.append(_editPartClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartsPackageName = it.getDiagram().getEditPartsPackageName();
    _builder.append(_editPartsPackageName);
    return _builder;
  }
  
  public CharSequence constructor(final GenNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("super(view);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence extendsList(final GenNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.papyrus.uml.diagram.common.editparts.AbstractNodeLabelEditPart");
    return _builder;
  }
  
  public CharSequence attributes(final GenNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _visualIDConstant = this.xptEditpartsCommon.visualIDConstant(it);
    _builder.append(_visualIDConstant);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence createDefaultEditPolicies(final GenNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void createDefaultEditPolicies() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.createDefaultEditPolicies();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.SELECTION_FEEDBACK_ROLE, new org.eclipse.papyrus.uml.diagram.common.editpolicies.UMLTextSelectionEditPolicy());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.DIRECT_EDIT_ROLE, new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE, new org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.edit.policies.DefaultNodeLabelDragPolicy());");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _behaviour = this.xptEditpartsCommon.behaviour(it);
    _builder.append(_behaviour, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence handleNotificationEventExtent(final GenNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((this._utils_qvto.isStoringChildPositions(it.getNode()) || it.isElementIcon())) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append(_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void handleNotificationEvent(org.eclipse.emf.common.notify.Notification event) {");
        _builder.newLine();
        {
          boolean _isStoringChildPositions = this._utils_qvto.isStoringChildPositions(it.getNode());
          if (_isStoringChildPositions) {
            _builder.append("\t");
            _builder.append("Object feature = event.getFeature();");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _handleBounds = this.xptEditpartsCommon.handleBounds(it);
            _builder.append(_handleBounds, "\t");
            _builder.newLineIfNotEmpty();
          }
        }
        {
          boolean _isElementIcon = it.isElementIcon();
          if (_isElementIcon) {
            _builder.append("if(event.getNewValue() instanceof org.eclipse.emf.ecore.EAnnotation && org.eclipse.papyrus.infra.emf.appearance.helper.VisualInformationPapyrusConstants.DISPLAY_NAMELABELICON.equals(((org.eclipse.emf.ecore.EAnnotation)event.getNewValue()).getSource())){\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("refreshLabel();");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
          }
        }
        _builder.append("\t\t\t\t\t");
        _builder.append("super.handleNotificationEvent(event);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
}
