/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.checkers;

import java.util.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.OpaqueResourceProvider;

final class ClassifiedURIImpl
implements OpaqueResourceProvider.ClassifiedURI {
    private final URI uri;
    private final Object classifier;

    ClassifiedURIImpl(URI uri, Object classifier) {
        this.uri = uri;
        this.classifier = classifier == null || String.valueOf(classifier).isBlank() ? DEFAULT_CLASSIFIER : classifier;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public Object classifier() {
        return this.classifier;
    }

    public int hashCode() {
        return Objects.hash(this.classifier, this.uri);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClassifiedURIImpl)) {
            return false;
        }
        ClassifiedURIImpl other = (ClassifiedURIImpl)obj;
        return Objects.equals(this.classifier, other.classifier) && Objects.equals(this.uri, other.uri);
    }

    public String toString() {
        return String.format("%s(%s)", this.classifier, this.uri);
    }
}

