/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.textedit.xtext.nested.editor;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.AbstractPageModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IEditorModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.configuration.ICustomDirectEditorConfiguration;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocument;
import org.eclipse.papyrus.infra.textedit.ui.provider.TextDocumentLabelProvider;
import org.eclipse.papyrus.infra.textedit.xtext.Activator;
import org.eclipse.papyrus.infra.textedit.xtext.nested.editor.PapyrusXTextEditor;
import org.eclipse.papyrus.infra.ui.extension.diagrameditor.AbstractEditorFactory;
import org.eclipse.papyrus.infra.ui.multidiagram.actionbarcontributor.ActionBarContributorRegistry;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.xtext.service.DefaultRuntimeModule;
import org.eclipse.xtext.ui.DefaultUiModule;
import org.eclipse.xtext.ui.shared.SharedStateModule;
import org.eclipse.xtext.util.Modules2;

public abstract class AbstractPapyrusXtextEditorFactory
extends AbstractEditorFactory {
    public AbstractPapyrusXtextEditorFactory(Class<? extends PapyrusXTextEditor> editorClass) {
        super(editorClass, "");
    }

    public AbstractPapyrusXtextEditorFactory() {
        this(PapyrusXTextEditor.class);
    }

    public IPageModel createIPageModel(Object pageIdentifier) {
        ServicesRegistry services = this.getServiceRegistry();
        ILabelProvider labels = ServiceUtils.getInstance().tryService((Object)services, LabelProviderService.class).map(lps -> lps.getLabelProvider(pageIdentifier)).orElseGet(TextDocumentLabelProvider::new);
        return new TextDocumentViewEditorModel(pageIdentifier, services, labels);
    }

    public boolean isPageModelFactoryFor(Object pageIdentifier) {
        if (pageIdentifier instanceof TextDocument) {
            TextDocument txtDocument = (TextDocument)pageIdentifier;
            return this.getSupportedImplementationID().equals(txtDocument.getType());
        }
        return false;
    }

    private Injector createInjector() {
        DefaultRuntimeModule runtimeModule = this.getRuntimeModule();
        Module sharedStateModule = this.getSharedStateModule();
        DefaultUiModule uiModule = this.getUiModule();
        Module mergedModule = Modules2.mixin((Module[])new Module[]{runtimeModule, sharedStateModule, uiModule});
        return Guice.createInjector((Module[])new Module[]{mergedModule});
    }

    protected abstract DefaultRuntimeModule getRuntimeModule();

    protected abstract DefaultUiModule getUiModule();

    protected Module getSharedStateModule() {
        return new SharedStateModule();
    }

    protected abstract ICustomDirectEditorConfiguration getDirectEditorConfiguration();

    protected abstract String getFileExtension();

    protected abstract String getSupportedImplementationID();

    private class TextDocumentViewEditorModel
    extends AbstractPageModel
    implements IEditorModel {
        private ServicesRegistry servicesRegistry;
        private IEditorPart editor;
        private TextDocument rawModel;

        public TextDocumentViewEditorModel(Object pageIdentifier, ServicesRegistry servicesRegistry, ILabelProvider labels) {
            super(labels);
            this.rawModel = (TextDocument)pageIdentifier;
            this.servicesRegistry = servicesRegistry;
        }

        public IEditorPart createIEditorPart() throws PartInitException {
            Class clazz = AbstractPapyrusXtextEditorFactory.this.getDiagramClass();
            Injector injector = AbstractPapyrusXtextEditorFactory.this.createInjector();
            try {
                Object result = injector.getInstance(clazz);
                if (result instanceof PapyrusXTextEditor) {
                    PapyrusXTextEditor pte = (PapyrusXTextEditor)((Object)result);
                    pte.configureXTextEditor(this.servicesRegistry, this.rawModel, AbstractPapyrusXtextEditorFactory.this.getDirectEditorConfiguration(), AbstractPapyrusXtextEditorFactory.this.getFileExtension());
                    this.editor = (IEditorPart)result;
                }
                return this.editor;
            }
            catch (Exception e) {
                throw new PartInitException(NLS.bind((String)"Can't create the editor {0}", (Object)AbstractPapyrusXtextEditorFactory.this.getDiagramClass().getName()), (Throwable)e);
            }
        }

        public EditorActionBarContributor getActionBarContributor() {
            ActionBarContributorRegistry registry;
            String actionBarId = AbstractPapyrusXtextEditorFactory.this.editorDescriptor.getActionBarContributorId();
            if (actionBarId == null || actionBarId.length() == 0) {
                return null;
            }
            try {
                registry = (ActionBarContributorRegistry)this.servicesRegistry.getService(ActionBarContributorRegistry.class);
            }
            catch (ServiceException e) {
                return null;
            }
            try {
                return registry.getActionBarContributor((Object)actionBarId);
            }
            catch (BackboneException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
        }

        public Object getRawModel() {
            return this.rawModel;
        }
    }
}

