/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.commands.MoveElementsCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.edit.context.TypeContext;
import org.eclipse.papyrus.infra.types.core.utils.ElementTypeRegistryUtils;
import org.eclipse.papyrus.uml.service.types.Activator;
import org.eclipse.papyrus.uml.service.types.element.UMLDIElementTypes;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.service.types.helper.advice.AbstractReferenceDeleteRelationshipEditHelperAdvice;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.uml2.uml.UMLPackage;

public class ContainmentLinkDestroyEditHelperAdvice
extends AbstractReferenceDeleteRelationshipEditHelperAdvice {
    @Override
    protected boolean checkSourceEdgeToFindConnectorToDestroy() {
        return true;
    }

    @Override
    protected boolean checkTargetEdgeToFindConnectorToDestroy() {
        return false;
    }

    @Override
    protected Map<String, EReference> getFeatureElementTypeToEReferenceMap() {
        return Collections.singletonMap(UMLElementTypes.ELEMENT_OWNEDELEMENT.getId(), UMLPackage.eINSTANCE.getElement_OwnedElement());
    }

    protected ICommand getAfterDestroyReferenceCommand(DestroyReferenceRequest request) {
        Object affectedView = request.getParameter("AFFECTED_VIEW");
        if (affectedView instanceof Connector && this.isViewElementTypeTypeOf((View)affectedView, UMLDIElementTypes.ELEMENT_CONTAINMENT_EDGE)) {
            return this.getReparentCommand(request.getReferencedObject(), (Connector)affectedView);
        }
        return super.getAfterDestroyReferenceCommand(request);
    }

    protected ICommand getAfterReorientReferenceRelationshipCommand(ReorientReferenceRelationshipRequest request) {
        Object graphicalEdge = request.getParameter("graphical_edge");
        if (graphicalEdge instanceof Connector && this.isViewElementTypeTypeOf((View)graphicalEdge, UMLDIElementTypes.ELEMENT_CONTAINMENT_EDGE) && 2 == request.getDirection()) {
            return this.getReparentCommand(request.getOldRelationshipEnd(), (Connector)graphicalEdge);
        }
        return super.getAfterReorientReferenceRelationshipCommand(request);
    }

    private ICommand getReparentCommand(EObject elementToReparent, Connector containmentLink) {
        EObject targetContainer = containmentLink.getTarget().eContainer();
        if (targetContainer instanceof View) {
            EObject newContainer = ((View)targetContainer).getElement();
            MoveRequest moveRequest = new MoveRequest(newContainer, elementToReparent);
            MoveElementsCommand command = new MoveElementsCommand(moveRequest);
            return command;
        }
        return null;
    }

    private boolean isViewElementTypeTypeOf(View view, IHintedType expectedType) {
        boolean isTypeOf = false;
        try {
            IClientContext context = TypeContext.getContext((EObject)view);
            List elementTypes = ElementTypeRegistryUtils.getElementTypesBySemanticHint((String)view.getType(), (String)context.getId());
            for (IElementType iElementType : elementTypes) {
                isTypeOf |= ElementUtil.isTypeOf(iElementType, (IElementType)expectedType);
            }
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        return isTypeOf;
    }
}

