/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.PapyrusWrappingLabel;
import org.eclipse.papyrus.uml.diagram.common.figure.node.RoundedCompartmentFigure;

public class StateFigure
extends RoundedCompartmentFigure {
    protected String submachineStateName = "";
    protected boolean isSubmachineState = false;
    protected boolean isLeafState = false;
    protected PapyrusWrappingLabel finalLabel;
    private static final String FINAL_LABEL_VALUE = "final";
    private static final String STATE_COMPARTMENT = "stateCompartment";
    private static final List<String> COMPARTMENT = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(StateFigure.STATE_COMPARTMENT);
        }
    };

    public StateFigure() {
        this(null);
    }

    public StateFigure(String tagLabel) {
        super(COMPARTMENT, tagLabel);
        this.createFinalLabel();
    }

    public void setSubmachineStateName(String text) {
        this.submachineStateName = text;
    }

    public void setIsSubmachineState(boolean b) {
        this.isSubmachineState = b;
    }

    public void setIsLeafState(boolean isLeafState) {
        this.isLeafState = isLeafState;
    }

    public RectangleFigure getStateCompartmentFigure() {
        return this.getCompartment(STATE_COMPARTMENT);
    }

    protected void createFinalLabel() {
        this.finalLabel = new PapyrusWrappingLabel();
        String textToDisplay = new StringBuffer(CHEVRON).insert(1, FINAL_LABEL_VALUE).toString();
        this.finalLabel.setText(textToDisplay);
        this.finalLabel.setOpaque(false);
        this.finalLabel.setAlignment(this.namePosition);
        this.finalLabel.setForegroundColor(this.getNameLabel().getForegroundColor());
        this.finalLabel.setFont(this.getNameLabel().getFont());
        if (this.isLeafState) {
            this.getTagLabelContainer().add((IFigure)this.finalLabel, this.getTagLabelConstraint(), this.getFinalLabelPosition());
        }
    }

    public void restoreFinalLabel() {
        if (this.isLeafState && this.finalLabel != null) {
            this.finalLabel.setOpaque(false);
            this.finalLabel.setAlignment(this.namePosition);
            this.getFinalLabelContainer().add((IFigure)this.finalLabel, this.getFinalLabelConstraint(), this.getFinalLabelPosition());
        } else {
            this.removeFinalLabel();
        }
    }

    protected void removeFinalLabel() {
        if (this.finalLabel != null && this.getFinalLabelContainer().getChildren().contains(this.finalLabel)) {
            this.getFinalLabelContainer().remove((IFigure)this.finalLabel);
        }
    }

    protected int getFinalLabelPosition() {
        int position = 0;
        if (this.getFinalLabelContainer().equals(this.getNameLabelContainer())) {
            position = this.getNameLabelPosition();
            if (this.nameLabel != null) {
                ++position;
            }
        } else if (this.getFinalLabelContainer().equals(this.getQualifiedNameLabelContainer())) {
            position = this.getQualifiedNameLabelPosition();
            if (this.qualifiedLabel != null) {
                ++position;
            }
        } else if (this.getFinalLabelContainer().equals(this.getStereotypePropertiesInBraceLabelContainer())) {
            position = this.getStereotypePropertiesLabelPosition();
            if (this.stereotypePropertiesInBraceContent != null) {
                ++position;
            }
        } else if (this.getFinalLabelContainer().equals(this.getStereotypeLabelContainer())) {
            position = this.getStereotypeLabelPosition();
            if (this.stereotypesLabel != null) {
                ++position;
            }
        } else if (this.getFinalLabelContainer().equals(this.getIconLabelContainer())) {
            position = this.getIconLabelPosition();
            if (this.iconLabel != null && this.iconLabel.getIcon() != null) {
                ++position;
            }
        }
        return position;
    }

    protected Object getFinalLabelConstraint() {
        return this.getDefaultLabelsConstraint();
    }

    protected IFigure getFinalLabelContainer() {
        return this.getDefaultLabelsContainer();
    }

    protected int getNameHeight() {
        int nameHeight = super.getNameHeight();
        if (this.finalLabel != null && this.getFinalLabelContainer().equals(this.getNameLabelContainer())) {
            nameHeight += this.finalLabel.getPreferredSize().height;
        }
        return nameHeight;
    }
}

