/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.menu;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.ui.menu.NameNormalization;

public abstract class NameNormalizationCommand
extends RecordingCommand
implements NameNormalization {
    protected EObject source;
    protected String parameter;
    private final String BLANK = new String("");
    private final String SPACE = new String(" ");
    private final String MULTISPACE = new String(" +");
    private final String UNDERSCORE = new String("_");
    private final String MULTIUNDERSCORE = new String("_+");
    public static final String NAME_ACTION = "name quick formatting action";
    public static final String DEFAULT_ACTION = "default";
    public static final String UPPERCASE_ACTION = "uppercase";
    public static final String LOWERCASE_ACTION = "lowercase";
    public static final String SWITCHSPACE2UNDERSCORE_ACTION = "switchSpace2Underscore";
    public static final String CAPITALIZEFIRSTLETTER_ACTION = "capitalizeFirstLetter";
    public static final String REMOVESPACE_ACTION = "removeSpace";

    public NameNormalizationCommand(TransactionalEditingDomain domain, EObject source, String normalization) {
        super(domain, "name quick formatting action: " + normalization);
        this.source = source;
        this.parameter = normalization;
    }

    @Override
    public String normalizeName(String name, String parameter) {
        String newName = new String(name);
        switch (parameter) {
            case "uppercase": {
                newName = this.getUpperCaseName(name);
                break;
            }
            case "lowercase": {
                newName = this.getLowerCaseName(name);
                break;
            }
            case "switchSpace2Underscore": {
                newName = this.switchSpace2UnderscoreName(name);
                break;
            }
            case "removeSpace": {
                newName = this.removeSpaceName(name);
                break;
            }
            case "capitalizeFirstLetter": {
                newName = this.capitalizeName(name);
                break;
            }
            default: {
                newName = new String(name);
            }
        }
        return newName;
    }

    private String capitalizeName(String name) {
        String[] ns = name.split(" ");
        StringBuffer finalName = new StringBuffer();
        String[] stringArray = ns;
        int n = ns.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            finalName.append(String.valueOf(n3.substring(0, 1).toUpperCase()) + n3.substring(1, n3.length()) + " ");
            ++n2;
        }
        return finalName.toString().trim();
    }

    private String removeSpaceName(String name) {
        StringBuffer finalName = new StringBuffer();
        int spacePos = name.indexOf(this.SPACE);
        if (spacePos > 0) {
            finalName.append(name.replace(this.SPACE, this.BLANK));
        } else {
            finalName.append(name.replaceAll("(.)([A-Z])", "$1 $2"));
        }
        return finalName.toString().trim();
    }

    private String getUpperCaseName(String name) {
        return name.toUpperCase().trim();
    }

    private String getLowerCaseName(String name) {
        return name.toLowerCase().trim();
    }

    private String switchSpace2UnderscoreName(String name) {
        StringBuffer finalName = new StringBuffer();
        int underscorePos = name.indexOf(this.UNDERSCORE);
        int spacePos = name.indexOf(this.SPACE);
        if (underscorePos > 0 && spacePos > 0 && underscorePos < spacePos) {
            finalName.append(name.replace(this.UNDERSCORE, this.BLANK));
        } else if (underscorePos > 0 && spacePos > 0 && underscorePos > spacePos) {
            finalName.append(name.replace(this.SPACE, this.UNDERSCORE));
        } else if (underscorePos < 0 && spacePos > 0) {
            finalName.append(name.replace(this.SPACE, this.UNDERSCORE));
        } else if (underscorePos > 0 && spacePos < 0) {
            finalName.append(name.replace(this.UNDERSCORE, this.SPACE));
        }
        return finalName.toString().trim().replaceAll(this.MULTISPACE, this.SPACE).replaceAll(this.MULTIUNDERSCORE, this.UNDERSCORE);
    }
}

