/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.filters.internal.operations;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.papyrus.infra.filters.CompoundFilter;
import org.eclipse.papyrus.infra.filters.Filter;
import org.eclipse.papyrus.infra.filters.internal.FiltersPlugin;

public class CompoundFilterOperations {
    protected CompoundFilterOperations() {
    }

    public static boolean matches(CompoundFilter compoundFilter, Object input) {
        boolean result;
        block0 : switch (compoundFilter.getOperator()) {
            case AND: {
                result = false;
                for (Filter next : compoundFilter.getFilters()) {
                    result = next.matches(input);
                    if (!result) break block0;
                }
                break;
            }
            case OR: {
                result = false;
                for (Filter next : compoundFilter.getFilters()) {
                    result = next.matches(input);
                    if (result) break block0;
                }
                break;
            }
            case XOR: {
                int count = 0;
                for (Filter next : compoundFilter.getFilters()) {
                    count += next.matches(input) ? 1 : 0;
                }
                result = count == 1;
                break;
            }
            case NOT: {
                result = true;
                for (Filter next : compoundFilter.getFilters()) {
                    boolean bl = result = !next.matches(input);
                    if (!result) break block0;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unrecognized composite filter operator: " + compoundFilter.getOperator().getName());
            }
        }
        return result;
    }

    public static boolean validateAcyclic(CompoundFilter compoundFilter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        AbstractTreeIterator<Filter> allFilters = new AbstractTreeIterator<Filter>((Object)compoundFilter, false){
            private static final long serialVersionUID = 1L;

            protected Iterator<? extends Filter> getChildren(Object object) {
                return object instanceof CompoundFilter ? ((CompoundFilter)object).getFilters().iterator() : Collections.emptyIterator();
            }
        };
        while (allFilters.hasNext()) {
            if (allFilters.next() != compoundFilter) continue;
            result = false;
            break;
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.filters", 1, FiltersPlugin.INSTANCE.getString("_UI_acyclic_diagnostic", new Object[]{EObjectValidator.getObjectLabel((EObject)compoundFilter, context)}), new Object[]{compoundFilter}));
        }
        return result;
    }
}

