/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.xwt;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.constraints.ConstraintDescriptor;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;
import org.eclipse.papyrus.infra.constraints.runtime.ConstraintFactory;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.internal.ui.Activator;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSource;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSourceFactory;
import org.eclipse.papyrus.infra.properties.ui.runtime.DisplayEngine;
import org.eclipse.papyrus.infra.widgets.editors.EditorParentComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class XWTSection
extends AbstractPropertySection
implements IChangeListener {
    private Section section;
    private DataSource source;
    private View view;
    private Composite self;
    private DisplayEngine display;
    private Set<Constraint> constraints;

    public XWTSection(Section section, View view, DisplayEngine display) {
        this.section = section;
        this.view = view;
        this.display = display;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.self = new EditorParentComposite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.self.setLayout((Layout)layout);
        layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        this.self.setLayoutData((Object)data);
        this.self.setBackground(parent.getBackground());
        this.self.setBackgroundMode(1);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (selection == this.getSelection()) {
            return;
        }
        DataSourceFactory.instance.removeFromCache(this.getSelection(), this.view);
        super.setInput(part, selection);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.setSource(DataSourceFactory.instance.createDataSourceFromSelection(structuredSelection, this.view));
        }
    }

    private void setSource(DataSource source) {
        DataSource oldSource = this.source;
        if (oldSource != source) {
            if (oldSource != null && this.section.getConstraints().size() == 0) {
                oldSource.removeChangeListener(this);
                oldSource.autoRelease();
            }
            this.source = source;
            if (source != null) {
                source.retain();
                if (this.section.getConstraints().size() > 0) {
                    source.addChangeListener(this);
                }
            }
        }
    }

    public void display(boolean refresh) {
        if (this.self.isDisposed()) {
            Activator.log.debug("Error : widget is disposed");
            this.dispose();
            return;
        }
        if (!this.isApplied()) {
            this.display.storeConstraintevalutionForSource(this.section, this.source);
            this.hide();
            return;
        }
        this.self.setRedraw(false);
        if (refresh) {
            this.display.refreshSection(this.self, this.section, this.source);
        } else {
            this.display.createSection(this.self, this.section, this.source);
        }
        this.self.setRedraw(true);
    }

    private void hide() {
        this.display.removeSection(this.self);
    }

    public void refresh() {
        this.display(false);
    }

    protected boolean isApplied() {
        if (this.getConstraints().isEmpty()) {
            return true;
        }
        IStructuredSelection selection = this.getSelection();
        List selectionList = selection.toList();
        for (Constraint constraint : this.getConstraints()) {
            if (!constraint.match((Collection)selectionList)) continue;
            return true;
        }
        return false;
    }

    protected Set<Constraint> getConstraints() {
        if (this.constraints == null) {
            this.constraints = new HashSet<Constraint>();
            for (ConstraintDescriptor constraintDescriptor : this.section.getConstraints()) {
                Constraint constraint = ConstraintFactory.getInstance().createFromModel(constraintDescriptor);
                if (constraint == null) continue;
                this.constraints.add(constraint);
            }
        }
        return this.constraints;
    }

    public void dispose() {
        if (this.source != null) {
            this.source.removeChangeListener(this);
            this.source.release();
        }
        if (this.self != null) {
            this.self.dispose();
        }
        DataSourceFactory.instance.removeFromCache(this.getSelection(), this.view);
        super.dispose();
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)super.getSelection();
    }

    public String toString() {
        return "XWTSection : " + this.section.getName();
    }

    public void handleChange(ChangeEvent event) {
        this.display(true);
    }
}

