/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.architecture.handlers;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsPackage;
import org.eclipse.papyrus.infra.ui.architecture.messages.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddRecommendedElementTypesConfigurationsHandler
extends AbstractHandler {
    private static final URI REPRESENTATIONS_ADVICE_URI = URI.createURI((String)"pathmap://PAPYRUS_VIEWPOINTS_POLICY/representations/advice", (boolean)true);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EditingDomain domain;
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        List<ArchitectureContext> contexts = this.getArchitectureContexts(selection);
        if (!contexts.isEmpty() && (domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)((EObject)contexts.get(0)))) != null) {
            Shell parent = HandlerUtil.getActiveShell((ExecutionEvent)event);
            domain.getCommandStack().execute(this.getAddElementTypeSetConfigurationsCommand(parent, domain, contexts));
        }
        return null;
    }

    private List<ArchitectureContext> getArchitectureContexts(IStructuredSelection selection) {
        return selection.toList().stream().filter(ArchitectureContext.class::isInstance).map(ArchitectureContext.class::cast).collect(Collectors.toList());
    }

    private Command getAddElementTypeSetConfigurationsCommand(Shell parent, EditingDomain domain, Collection<? extends ArchitectureContext> contexts) {
        EList selectedSets;
        Collection<ElementTypeSetConfiguration> recommendedSets = this.getRecommendedElementTypesConfigurations(domain);
        Object adapterFactory = domain instanceof AdapterFactoryEditingDomain ? ((AdapterFactoryEditingDomain)domain).getAdapterFactory() : new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        AdapterFactoryLabelProvider labels = new AdapterFactoryLabelProvider(adapterFactory);
        try {
            FeatureEditorDialog dialog = new FeatureEditorDialog(parent, (ILabelProvider)labels, (Object)Messages.AddRecommendedElementTypesConfigurationsHandler_1, (EClassifier)ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_SET_CONFIGURATION, List.of(), Messages.AddRecommendedElementTypesConfigurationsHandler_2, List.copyOf(recommendedSets), true, true, true);
            selectedSets = dialog.open() == 0 ? dialog.getResult() : List.of();
        }
        finally {
            if (!(domain instanceof AdapterFactoryEditingDomain)) {
                ((ComposedAdapterFactory)adapterFactory).dispose();
            }
            labels.dispose();
        }
        return contexts.stream().map(arg_0 -> this.lambda$2(domain, (Collection)selectedSets, arg_0)).filter(Objects::nonNull).reduce(Command::chain).orElse((Command)UnexecutableCommand.INSTANCE);
    }

    private Collection<ElementTypeSetConfiguration> getRecommendedElementTypesConfigurations(EditingDomain domain) {
        Resource resource = domain.getResourceSet().getResource(REPRESENTATIONS_ADVICE_URI, true);
        return resource == null ? List.of() : EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_SET_CONFIGURATION);
    }

    private Command getAddElementTypeSetConfigurationsCommand(EditingDomain domain, ArchitectureContext context, Collection<?> recommendedSets) {
        HashSet toAdd = new HashSet(recommendedSets);
        toAdd.removeAll((Collection<?>)context.getElementTypes());
        return toAdd.isEmpty() ? null : AddCommand.create((EditingDomain)domain, (Object)context, (Object)ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__ELEMENT_TYPES, toAdd);
    }

    private /* synthetic */ Command lambda$2(EditingDomain editingDomain, Collection collection, ArchitectureContext ctx) {
        return this.getAddElementTypeSetConfigurationsCommand(editingDomain, ctx, collection);
    }
}

