/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.expressions.edit.internal.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.uml.expressions.edit.internal.utils.PackageUtils;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class ProfileUtils {
    public static final Collection<Profile> findAttachedRootProfiles(EObject anEobject) {
        HashSet<Profile> profiles = new HashSet<Profile>();
        if (anEobject.eResource() != null && anEobject.eResource().getResourceSet() != null) {
            ResourceSet set = anEobject.eResource().getResourceSet();
            for (Resource res : set.getResources()) {
                for (EObject eobject : res.getContents()) {
                    if (!(eobject instanceof Profile)) continue;
                    profiles.add((Profile)eobject);
                }
            }
        }
        return profiles;
    }

    public static final Stereotype findStereotype(EObject editedObject, String stereotypeQualifiedName) {
        List<String> namespaces = Arrays.asList(stereotypeQualifiedName.split("::"));
        Collection<Profile> profiles = ProfileUtils.findAttachedRootProfiles(editedObject);
        List findProfilesByName = profiles.stream().filter(p -> p.getName().equals(namespaces.get(0))).collect(Collectors.toList());
        if (findProfilesByName != null && findProfilesByName.size() == 1) {
            Profile profile = (Profile)findProfilesByName.get(0);
            ListIterator<String> iter = namespaces.listIterator();
            iter.next();
            Profile current = profile;
            while (iter.hasNext()) {
                NamedElement namedElement = current.getMember(iter.next());
                if (!(namedElement instanceof Namespace)) continue;
                current = (Namespace)namedElement;
            }
            if (current instanceof Stereotype) {
                return (Stereotype)current;
            }
        }
        return null;
    }

    public static final Profile findProfile(EObject editedObject, String profileURI) {
        if (profileURI == null || profileURI.isEmpty()) {
            return null;
        }
        Collection<Profile> profiles = ProfileUtils.findAttachedRootProfiles(editedObject);
        Iterator<Profile> iter = profiles.iterator();
        Profile foundProfile = null;
        while (iter.hasNext() && foundProfile == null) {
            foundProfile = PackageUtils.findPackageFromURI((Package)iter.next(), profileURI, Profile.class);
        }
        return foundProfile;
    }

    public static final Collection<Property> findStereotypeProperty(EObject editedEObject, String propertyName) {
        if (propertyName == null || propertyName.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        Collection<Profile> profiles = ProfileUtils.findAttachedRootProfiles(editedEObject);
        for (Profile current : profiles) {
            TreeIterator allContentsIterator = current.eAllContents();
            while (allContentsIterator.hasNext()) {
                EObject eobject = (EObject)allContentsIterator.next();
                if (!(eobject instanceof Property) || !(eobject.eContainer() instanceof Stereotype) || !propertyName.equals(((Property)eobject).getName())) continue;
                properties.add((Property)eobject);
            }
        }
        return properties;
    }
}

