/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.gmf.command;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.eclipse.emf.common.command.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;

public interface ICommandWrapper<T> {
    public static final Registry REGISTRY = new Registry();

    public T getWrappedCommand();

    public static <F, T> T wrap(F command, Class<T> type) {
        return REGISTRY.getWrapper(command, type).apply(command);
    }

    public static <F, T> boolean isWrapper(T command, Class<F> ofType) {
        return REGISTRY.hasUnwrapper(command, ofType);
    }

    public static <F, T> F unwrap(T command, Class<F> type) {
        return REGISTRY.getUnwrapper(command, type).apply(command);
    }

    public static class Registry {
        private final ConcurrentMap<Class<?>, ConcurrentMap<Class<?>, Function<?, ?>>> wrappers = new ConcurrentHashMap();
        private final ConcurrentMap<Class<?>, ConcurrentMap<Class<?>, Function<?, ?>>> unwrappers = new ConcurrentHashMap();

        private Registry() {
            this.registerWrapper(Command.class, ICommand.class, EMFtoGMFCommandWrapper::wrap);
            this.registerUnwrapper(EMFtoGMFCommandWrapper.class, Command.class, EMFtoGMFCommandWrapper::getWrappedCommand);
            this.registerWrapper(ICommand.class, Command.class, GMFtoEMFCommandWrapper::wrap);
            this.registerUnwrapper(GMFtoEMFCommandWrapper.class, ICommand.class, GMFtoEMFCommandWrapper::getWrappedCommand);
        }

        public <F, T> void registerWrapper(Class<F> fromType, Class<T> toType, Function<? super F, ? extends T> wrapper) {
            ConcurrentMap wrappers = this.wrappers.computeIfAbsent(fromType, key -> new ConcurrentHashMap());
            if (wrappers.putIfAbsent(toType, wrapper) != null) {
                throw new IllegalStateException(String.format("Wrapper already registered for %s -> %s", fromType.getSimpleName(), toType.getSimpleName()));
            }
        }

        public <F, T> void registerUnwrapper(Class<F> fromType, Class<T> toType, Function<? super F, ? extends T> unwrapper) {
            ConcurrentMap unwrappers = this.unwrappers.computeIfAbsent(fromType, key -> new ConcurrentHashMap());
            if (unwrappers.putIfAbsent(toType, unwrapper) != null) {
                throw new IllegalStateException(String.format("Unwrapper already registered for %s <- %s", toType.getSimpleName(), fromType.getSimpleName()));
            }
        }

        <F, T> Function<F, T> getWrapper(F command, Class<T> type) {
            return this.wrappers.entrySet().stream().filter(e -> ((Class)e.getKey()).isInstance(command)).flatMap(e -> ((ConcurrentMap)e.getValue()).entrySet().stream()).filter(e -> type.isAssignableFrom((Class)e.getKey())).map(Map.Entry::getValue).findFirst().orElseThrow(IllegalArgumentException::new);
        }

        <F, T> Function<T, F> getUnwrapper(T command, Class<F> type) {
            return this.maybeGetUnwrapper(command, type).orElseThrow(IllegalArgumentException::new);
        }

        boolean hasUnwrapper(Object command, Class<?> type) {
            return this.maybeGetUnwrapper(command, type).isPresent();
        }

        <F, T> Optional<Function<T, F>> maybeGetUnwrapper(T command, Class<F> type) {
            return this.unwrappers.entrySet().stream().filter(e -> ((Class)e.getKey()).isInstance(command)).flatMap(e -> ((ConcurrentMap)e.getValue()).entrySet().stream()).filter(e -> type.isAssignableFrom((Class)e.getKey())).map(Map.Entry::getValue).findFirst();
        }
    }
}

