/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.commands;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.resource.ShardResourceHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.services.controlmode.ControlModePlugin;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.AbstractControlCommand;
import org.eclipse.papyrus.infra.services.controlmode.messages.Messages;
import org.eclipse.papyrus.infra.services.controlmode.service.IUncontrolledObjectsProvider;

public class BasicUncontrolCommand
extends AbstractControlCommand {
    private static final String CONTROL_COMMAND_TITLE = Messages.getString("BasicUncontrolCommand.uncontrol.command.title");
    private static final String UNCONTROL_OBJECT_ERROR = Messages.getString("BasicUncontrolCommand.uncontrol.object.error");
    private static final String UNCONTROL_RESOURCE_ERROR = Messages.getString("BasicUncontrolCommand.uncontrol.object.resource.error");

    public BasicUncontrolCommand(ControlModeRequest request) {
        super(CONTROL_COMMAND_TITLE, Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)request.getTargetObject().eResource())), request);
    }

    public boolean canExecute() {
        return this.getRequest().getTargetObject().eResource() != null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        EObject uncontrolledObject = this.getRequest().getTargetObject();
        ModelSet modelSet = this.getRequest().getModelSet();
        Resource resource = modelSet.getResource(this.getRequest().getSourceURI(), true);
        if (resource != null) {
            try {
                IUncontrolledObjectsProvider service = (IUncontrolledObjectsProvider)ServiceUtilsForResource.getInstance().getService(IUncontrolledObjectsProvider.class, (Object)resource);
                service.addUncontrolledObject(resource, uncontrolledObject);
            }
            catch (ServiceException e) {
                ControlModePlugin.log.error(UNCONTROL_OBJECT_ERROR, (Throwable)e);
            }
            Throwable throwable = null;
            Object var7_9 = null;
            try (ShardResourceHelper helper = new ShardResourceHelper(uncontrolledObject);){
                helper.setShard(false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            resource.getContents().remove((Object)uncontrolledObject);
            resource.setModified(true);
            return CommandResult.newOKCommandResult();
        }
        return CommandResult.newErrorCommandResult((String)UNCONTROL_RESOURCE_ERROR);
    }
}

